/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.multi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.PropertyModelListener;
import oracle.bali.inspector.PropertyModelUpdateEvent;
import oracle.bali.inspector.multi.SelectionEvent;
import oracle.bali.inspector.multi.SelectionListener;
import oracle.bali.inspector.multi.SelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiObjectModel
extends PropertyModel {
    private static final Object _UNINITIALIZED_VALUE = new Object();
    private static final String _KEY_MULTIPLE = "MULTIPLE";
    private SelectionModel _selectionModel;
    private BitSet _commonProperties;
    private transient int _valueColumnIndex;
    private transient int _displayValueColumnIndex;
    private transient PropertyModel _primaryModel;
    private transient SelectionListenerImpl _listener;
    private transient Object[][] _mergedValues;
    private transient Vector<Object> _properties;
    private transient Object[] _columnIDs;
    private transient int[][] _columnMap;
    private transient BitSet _conflictFlags;

    private void $init$() {
        this._properties = new Vector();
    }

    public MultiObjectModel() {
        this.$init$();
        this._clearColumnData();
        this._listener = new SelectionListenerImpl();
    }

    @Override
    public Object[] getColumnMapping() {
        return this._columnIDs;
    }

    public void setSelectionModel(SelectionModel newSelectionModel) {
        if (this._selectionModel == newSelectionModel) {
            return;
        }
        if (this._selectionModel != null) {
            this._selectionModel.removeSelectionListener(this._listener);
            this._listener.__updateModelListeners(this._selectionModel, false);
        }
        this._selectionModel = newSelectionModel;
        if (newSelectionModel != null) {
            newSelectionModel.addSelectionListener(this._listener);
            this._listener.__updateModelListeners(newSelectionModel, true);
            this._updateProperties();
        } else {
            this._clearColumnData();
        }
    }

    public SelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    @Override
    public String getTargetDisplayName() {
        if (this._selectionModel == null) {
            return null;
        }
        int numTargets = this._selectionModel.getSelectedItemCount();
        if (numTargets == 0) {
            return null;
        }
        if (numTargets == 1) {
            return this._primaryModel.getTargetDisplayName();
        }
        return this._getTranslatedString(_KEY_MULTIPLE);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._selectionModel == null) {
            return;
        }
        int numTargets = this._selectionModel.getSelectedItemCount();
        int i = 0;
        while (i < numTargets) {
            PropertyModel ds = (PropertyModel)this._selectionModel.getSelectedItem(i);
            ds.setLocale(locale);
            ++i;
        }
        if (numTargets <= 1) {
            return;
        }
        this.firePropertyChanged("targetDisplayName", null, this._getTranslatedString(_KEY_MULTIPLE));
    }

    @Override
    public int getRowCount() {
        return this._properties.size();
    }

    @Override
    public boolean isDataConflicting(int columnIndex, int rowIndex) {
        this._getValue(columnIndex, rowIndex);
        int bit = columnIndex + this.getColumnCount() * rowIndex;
        boolean conflicting = this._getConflictFlags().get(bit);
        if (conflicting) {
            return true;
        }
        SelectionModel model = this.getSelectionModel();
        if (model != null) {
            int modelCount = model.getSelectedItemCount();
            int i = 0;
            while (i < modelCount) {
                PropertyModel child = (PropertyModel)model.getSelectedItem(i);
                if (rowIndex < child.getRowCount() && child.isDataConflicting(columnIndex, rowIndex)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this._getValue(columnIndex, rowIndex);
    }

    @Override
    public void setValueAt(Object data, int rowIndex, int columnIndex) {
        if (this._selectionModel == null) {
            return;
        }
        this._getConflictFlags().clear(columnIndex + this.getColumnCount() * rowIndex);
        Object propertyID = this._properties.elementAt(rowIndex);
        int numModels = this._selectionModel.getSelectedItemCount();
        int i = 0;
        while (i < numModels) {
            PropertyModel current = (PropertyModel)this._selectionModel.getSelectedItem(i);
            try {
                current.setPropertyByID(this._columnMap[i][columnIndex], propertyID, data);
                this.invalidateValueData();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                this.throwIllegalArgumentException(t, this.getPropertyDisplayName(rowIndex, this.getLocale()), data);
            }
            ++i;
        }
        if (rowIndex < this.getRowCount()) {
            this._invalidateCell(columnIndex, rowIndex);
        }
    }

    @Override
    public Object getPropertyByID(int columnIndex, Object propertyID) {
        int rowIndex = this._getRowIndex(propertyID);
        if (rowIndex == -1) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        return this.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setPropertyByID(int columnIndex, Object propertyID, Object data) throws Exception {
        int rowIndex = this._getRowIndex(propertyID);
        if (rowIndex == -1) {
            return;
        }
        this.setValueAt(data, rowIndex, columnIndex);
    }

    @Override
    public Enumeration getPropertyIDs() {
        return this._properties.elements();
    }

    @Override
    public void invalidateValueData() {
        this._invalidateColumn(PropertyModel.COLUMN_VALUE);
        SelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        int modelCount = model.getSelectedItemCount();
        int i = 0;
        while (i < modelCount) {
            PropertyModel child = (PropertyModel)model.getSelectedItem(i);
            child.invalidateValueData();
            ++i;
        }
    }

    @Override
    public boolean isPropertyCommon(int rowIndex) {
        if (this._commonProperties != null && !this._commonProperties.get(rowIndex)) {
            return false;
        }
        SelectionModel model = this.getSelectionModel();
        if (model == null) {
            return true;
        }
        int modelCount = model.getSelectedItemCount();
        int i = 0;
        while (i < modelCount) {
            PropertyModel child = (PropertyModel)model.getSelectedItem(i);
            if (!child.isPropertyCommon(rowIndex)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        SelectionModel model = this.getSelectionModel();
        if (model != null) {
            int modelCount = model.getSelectedItemCount();
            int i = 0;
            while (i < modelCount) {
                PropertyModel child = (PropertyModel)model.getSelectedItem(i);
                child.dispose();
                ++i;
            }
        }
        this.setSelectionModel(null);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this._selectionModel == null) {
            return false;
        }
        boolean editable = false;
        int numTargets = this._selectionModel.getSelectedItemCount();
        int i = 0;
        while (i < numTargets) {
            PropertyModel ds = (PropertyModel)this._selectionModel.getSelectedItem(i);
            editable |= ds.isCellEditable(row, col);
            ++i;
        }
        return editable;
    }

    @Override
    public boolean isSettable(Object oldValue, Object newValue) {
        if (this._selectionModel == null) {
            return false;
        }
        boolean settable = false;
        int numTargets = this._selectionModel.getSelectedItemCount();
        int i = 0;
        while (i < numTargets) {
            PropertyModel ds = (PropertyModel)this._selectionModel.getSelectedItem(i);
            settable |= ds.isSettable(oldValue, newValue);
            ++i;
        }
        return settable;
    }

    @Override
    public void startRead() {
        super.startRead();
        if (this._selectionModel == null) {
            return;
        }
        int numTargets = this._selectionModel.getSelectedItemCount();
        int i = 0;
        while (i < numTargets) {
            PropertyModel ds = (PropertyModel)this._selectionModel.getSelectedItem(i);
            ds.startRead();
            ++i;
        }
    }

    @Override
    public Object getMatchingId(Object id) {
        SelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel == null) {
            return false;
        }
        int i = 0;
        while (i < selectionModel.getSelectedItemCount()) {
            PropertyModel model = (PropertyModel)selectionModel.getSelectedItem(i);
            Object realId = model.getMatchingId(id);
            if (realId != null) {
                return realId;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isMatchingPropertyID(Object id, int rowIndex) {
        SelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel == null) {
            return false;
        }
        Object propertyId = this._properties.elementAt(rowIndex);
        int i = 0;
        while (i < selectionModel.getSelectedItemCount()) {
            PropertyModel propertyModel = (PropertyModel)selectionModel.getSelectedItem(i);
            int realRowIndex = propertyModel.getPropertyIndex(propertyId);
            if (realRowIndex >= 0 && propertyModel.isMatchingPropertyID(id, realRowIndex)) {
                return true;
            }
            ++i;
        }
        return id.equals(propertyId);
    }

    @Override
    public void stopRead() {
        super.stopRead();
        if (this._selectionModel == null) {
            return;
        }
        int numTargets = this._selectionModel.getSelectedItemCount();
        int i = 0;
        while (i < numTargets) {
            PropertyModel ds = (PropertyModel)this._selectionModel.getSelectedItem(i);
            ds.stopRead();
            ++i;
        }
    }

    private String _getTranslatedString(String key) {
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.inspector.resource.InspectorBundle", this.getLocale());
        return b.getString(key);
    }

    private void _invalidateColumn(Object columnID) {
        this._invalidateColumn(this.getColumnIndex(columnID));
    }

    private void _invalidateColumn(int columnIndex) {
        int displayValueIndex;
        if (columnIndex == -1) {
            return;
        }
        Object[][] mergedValues = this._mergedValues;
        int numRows = this.getRowCount();
        if (mergedValues != null) {
            int y = 0;
            while (y < numRows) {
                mergedValues[columnIndex][y] = _UNINITIALIZED_VALUE;
                ++y;
            }
        }
        TableModelEvent event = new TableModelEvent(this, 0, numRows - 1, columnIndex);
        this.fireTableChanged(event);
        if (columnIndex == this._valueColumnIndex && (displayValueIndex = this._displayValueColumnIndex) != -1) {
            this._invalidateColumn(displayValueIndex);
        }
    }

    private void _invalidateRow(int rowIndex) {
        if (rowIndex == -1) {
            return;
        }
        Object[][] mergedValues = this._mergedValues;
        if (mergedValues == null) {
            return;
        }
        int numColumns = this.getColumnCount();
        int x = 0;
        while (x < numColumns) {
            mergedValues[x][rowIndex] = _UNINITIALIZED_VALUE;
            ++x;
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    private void _invalidateCell(int columnIndex, int rowIndex) {
        int displayValueIndex;
        if (columnIndex == -1 || rowIndex == -1) {
            return;
        }
        if (this._mergedValues != null) {
            this._mergedValues[columnIndex][rowIndex] = _UNINITIALIZED_VALUE;
        }
        if (rowIndex < this.getRowCount()) {
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
        if (columnIndex == this._valueColumnIndex && (displayValueIndex = this._displayValueColumnIndex) != -1) {
            this._invalidateCell(displayValueIndex, rowIndex);
        }
    }

    private BitSet _getConflictFlags() {
        if (this._conflictFlags == null) {
            this._conflictFlags = new BitSet(this.getColumnCount() * this.getRowCount());
        }
        return this._conflictFlags;
    }

    private Object _getValue(int columnIndex, int rowIndex) {
        Object[][] mergedValues = this._mergedValues;
        if (mergedValues == null) {
            int numColumns = this.getColumnCount();
            int numRows = this.getRowCount();
            mergedValues = new Object[numColumns][numRows];
            int i = 0;
            while (i < numRows) {
                int j = 0;
                while (j < numColumns) {
                    mergedValues[j][i] = _UNINITIALIZED_VALUE;
                    ++j;
                }
                ++i;
            }
            this._mergedValues = mergedValues;
        }
        Object value = this._mergedValues[columnIndex][rowIndex];
        if (columnIndex != this.getColumnIndex(PropertyModel.COLUMN_VALIDATION_ISSUES) && value != _UNINITIALIZED_VALUE) {
            return value;
        }
        int numModels = this._selectionModel != null ? this._selectionModel.getSelectedItemCount() : 0;
        Object propertyID = this._properties.elementAt(rowIndex);
        value = this._primaryModel.getPropertyByID(this._columnMap[0][columnIndex], propertyID);
        int i = 1;
        while (i < numModels) {
            PropertyModel current = (PropertyModel)this._selectionModel.getSelectedItem(i);
            Object newValue = current.getPropertyByID(this._columnMap[i][columnIndex], propertyID);
            if (newValue != value) {
                if (value == PropertyModel.DOES_NOT_EXIST) {
                    value = newValue;
                } else if (!(newValue == PropertyModel.DOES_NOT_EXIST || newValue != null && newValue.equals(value))) {
                    this._getConflictFlags().set(columnIndex + this.getColumnCount() * rowIndex);
                    break;
                }
            }
            ++i;
        }
        this._mergedValues[columnIndex][rowIndex] = value;
        return value;
    }

    private boolean _updateColumnMap() {
        int numOldColumns = this._columnIDs.length;
        int numModels = this._selectionModel.getSelectedItemCount();
        if (numModels > 0) {
            Object[] newColumnIDs;
            boolean numColumnsChanged;
            PropertyModel primary = (PropertyModel)this._selectionModel.getSelectedItem(0);
            Object[] primaryColumnIDs = primary.getColumnMapping();
            int numPrimaryColumns = primaryColumnIDs.length;
            ArrayList<Object> columnVector = new ArrayList<Object>(numModels);
            int i = 0;
            while (i < numPrimaryColumns) {
                columnVector.add(primaryColumnIDs[i]);
                ++i;
            }
            int i2 = 1;
            while (i2 < numModels) {
                PropertyModel currModel = (PropertyModel)this._selectionModel.getSelectedItem(i2);
                Object[] currColumnIDs = currModel.getColumnMapping();
                int numColumns = currColumnIDs.length;
                int j = 0;
                while (j < numColumns) {
                    Object currColumnID = currColumnIDs[j];
                    if (columnVector.indexOf(currColumnID) == -1) {
                        columnVector.add(currColumnID);
                    }
                    ++j;
                }
                ++i2;
            }
            boolean columnsChanged = true;
            int numNewColumns = columnVector.size();
            boolean bl = numColumnsChanged = numOldColumns != numNewColumns;
            if (!numColumnsChanged) {
                newColumnIDs = this._columnIDs;
                int i3 = 0;
                while (i3 < numOldColumns) {
                    if (!this._columnIDs[i3].equals(columnVector.get(i3))) {
                        this._columnIDs = null;
                        break;
                    }
                    ++i3;
                }
                columnsChanged = i3 != numOldColumns;
            } else {
                newColumnIDs = new Object[numNewColumns];
            }
            columnVector.toArray(newColumnIDs);
            this._columnIDs = newColumnIDs;
            int numOldModels = this._columnMap.length;
            Object newColumnMap = numOldModels == numModels ? this._columnMap : (Object)new int[numModels][];
            int i4 = 0;
            while (i4 < numModels) {
                int[] currColumnMap = !numColumnsChanged && i4 < numOldModels ? this._columnMap[i4] : new int[numNewColumns];
                PropertyModel currModel = (PropertyModel)this._selectionModel.getSelectedItem(i4);
                Object[] currColumnIDs = currModel.getColumnMapping();
                int currNumColumns = currColumnIDs.length;
                int j = 0;
                while (j < numNewColumns) {
                    Object currColumnID = newColumnIDs[j];
                    int k = 0;
                    while (k < currNumColumns) {
                        if (currColumnID == currColumnIDs[k]) break;
                        ++k;
                    }
                    currColumnMap[j] = k < currNumColumns ? k : -1;
                    ++j;
                }
                newColumnMap[i4] = currColumnMap;
                ++i4;
            }
            this._columnMap = newColumnMap;
            if (columnsChanged) {
                this._updateCachedIndices();
            }
            return columnsChanged;
        }
        this._clearColumnData();
        return numOldColumns != 0;
    }

    private int _getRowIndex(Object propertyID) {
        int rowIndex = this._properties.indexOf(propertyID);
        if (rowIndex != -1) {
            return rowIndex;
        }
        return -1;
    }

    private synchronized void _updateProperties() {
        this._mergedValues = null;
        this._conflictFlags = null;
        this._commonProperties = null;
        PropertyModel newPrimary = null;
        Vector<Object> properties = new Vector<Object>();
        PropertyModel oldPrimary = this._primaryModel;
        int numModels = this._selectionModel.getSelectedItemCount();
        if (numModels > 0) {
            Map[] modelProperties = null;
            if (numModels > 1) {
                modelProperties = new Map[numModels];
                int i = 1;
                while (i < numModels) {
                    PropertyModel currModel = (PropertyModel)this._selectionModel.getSelectedItem(i);
                    currModel.startRead();
                    try {
                        modelProperties[i] = this.createIdMap(currModel.getPropertyIDs());
                    }
                    finally {
                        currModel.stopRead();
                    }
                    ++i;
                }
            }
            newPrimary = (PropertyModel)this._selectionModel.getSelectedItem(0);
            int numPrimaryProperties = newPrimary.getRowCount();
            properties = new Vector(numPrimaryProperties);
            BitSet commonProperties = new BitSet(numPrimaryProperties);
            newPrimary.startRead();
            try {
                int i = 0;
                while (i < numPrimaryProperties) {
                    boolean isCommon = true;
                    Object currKey = newPrimary.getPropertyID(i);
                    properties.addElement(currKey);
                    int j = 1;
                    while (j < numModels) {
                        Object currObject = modelProperties[j].remove(currKey);
                        isCommon &= currObject != null;
                        ++j;
                    }
                    if (isCommon) {
                        commonProperties.set(i);
                    }
                    ++i;
                }
            }
            finally {
                newPrimary.stopRead();
            }
            this._commonProperties = commonProperties;
            int i = 1;
            while (i < numModels) {
                Set keys = modelProperties[i].keySet();
                for (Object currKey : keys) {
                    properties.addElement(currKey);
                    int j = i + 1;
                    while (j < numModels) {
                        modelProperties[j].remove(currKey);
                        ++j;
                    }
                }
                ++i;
            }
        }
        this._properties = properties;
        this._primaryModel = newPrimary;
        this._updateColumnMap();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        if (newPrimary != oldPrimary) {
            String oldValue = oldPrimary != null ? oldPrimary.getTargetDisplayName() : null;
            String newValue = newPrimary != null ? newPrimary.getTargetDisplayName() : null;
            this.firePropertyChanged("targetDisplayName", oldValue, newValue);
        }
    }

    private void _fireDisplayChange(String oldValue, String newValue) {
        if (this._selectionModel != null && this._selectionModel.getSelectedItemCount() == 1) {
            this.firePropertyChanged("targetDisplayName", oldValue, newValue);
        }
    }

    private void _clearColumnData() {
        this._columnIDs = new Object[0];
        this._columnMap = new int[0][0];
        this._updateCachedIndices();
    }

    private Map<Object, Object> createIdMap(Enumeration propertyIDs) {
        HashMap<Object, Object> idHashTable = new HashMap<Object, Object>();
        while (propertyIDs.hasMoreElements()) {
            Object currPropertyID = propertyIDs.nextElement();
            idHashTable.put(currPropertyID, _UNINITIALIZED_VALUE);
        }
        return idHashTable;
    }

    private void _updateCachedIndices() {
        this._valueColumnIndex = this.getColumnIndex(PropertyModel.COLUMN_VALUE);
        this._displayValueColumnIndex = this.getColumnIndex(PropertyModel.COLUMN_DISPLAY_VALUE);
    }

    static int mav$_getRowIndex(MultiObjectModel multiObjectModel, Object object) {
        return multiObjectModel._getRowIndex(object);
    }

    static void mav$_invalidateCell(MultiObjectModel multiObjectModel, int n, int n2) {
        multiObjectModel._invalidateCell(n, n2);
    }

    static void mav$_invalidateRow(MultiObjectModel multiObjectModel, int n) {
        multiObjectModel._invalidateRow(n);
    }

    static void mav$_updateProperties(MultiObjectModel multiObjectModel) {
        multiObjectModel._updateProperties();
    }

    static void mav$firePropertyModelUpdate(MultiObjectModel multiObjectModel, PropertyModelUpdateEvent propertyModelUpdateEvent) {
        multiObjectModel.firePropertyModelUpdate(propertyModelUpdateEvent);
    }

    static void mav$_fireDisplayChange(MultiObjectModel multiObjectModel, String string, String string2) {
        multiObjectModel._fireDisplayChange(string, string2);
    }

    private class SelectionListenerImpl
    implements SelectionListener,
    TableModelListener,
    PropertyChangeListener,
    PropertyModelListener {
        public void propertyChange(PropertyChangeEvent e) {
            if ("targetDisplayName".equals(e.getPropertyName())) {
                MultiObjectModel.mav$_fireDisplayChange(MultiObjectModel.this, (String)e.getOldValue(), (String)e.getNewValue());
            }
        }

        public void updatePropertyInspector(PropertyModelUpdateEvent event) {
            MultiObjectModel.mav$firePropertyModelUpdate(MultiObjectModel.this, event);
        }

        public void itemsAdded(SelectionEvent event) {
            this._updateListeners(event, true);
            MultiObjectModel.mav$_updateProperties(MultiObjectModel.this);
        }

        public void itemsRemoving(SelectionEvent event) {
            this._updateListeners(event, false);
        }

        public void itemsRemoved(SelectionEvent event) {
            MultiObjectModel.mav$_updateProperties(MultiObjectModel.this);
        }

        public void tableChanged(TableModelEvent e) {
            int type = e.getType();
            if (type != 0 || e.getLastRow() == Integer.MAX_VALUE) {
                MultiObjectModel.mav$_updateProperties(MultiObjectModel.this);
            } else if (e.getColumn() == -1) {
                this._invalidateRows(e);
            } else {
                this._invalidateCells(e);
            }
        }

        private void _invalidateRows(TableModelEvent event) {
            if (event.getFirstRow() == -1) {
                return;
            }
            int startIndex = event.getFirstRow();
            int endIndex = event.getLastRow();
            PropertyModel model = (PropertyModel)event.getSource();
            int i = startIndex;
            while (i <= endIndex) {
                MultiObjectModel.mav$_invalidateRow(MultiObjectModel.this, MultiObjectModel.mav$_getRowIndex(MultiObjectModel.this, model.getPropertyID(i)));
                ++i;
            }
        }

        private void _invalidateCells(TableModelEvent event) {
            PropertyModel model = (PropertyModel)event.getSource();
            int columnIndex = event.getColumn();
            int startRowIndex = event.getFirstRow();
            int endRowIndex = event.getLastRow();
            Object[] columnMapping = model.getColumnMapping();
            model.startRead();
            try {
                int j = startRowIndex;
                while (j <= endRowIndex) {
                    int rowIndex = MultiObjectModel.mav$_getRowIndex(MultiObjectModel.this, model.getPropertyID(j));
                    MultiObjectModel.mav$_invalidateCell(MultiObjectModel.this, MultiObjectModel.this.getColumnIndex(columnMapping[columnIndex]), rowIndex);
                    ++j;
                }
            }
            finally {
                model.stopRead();
            }
        }

        void __updateModelListeners(SelectionModel model, boolean addListeners) {
            int count = model.getSelectedItemCount();
            int i = 0;
            while (i < count) {
                PropertyModel currModel = (PropertyModel)model.getSelectedItem(i);
                if (addListeners) {
                    this.addListenersTo(currModel);
                } else {
                    this.removeListenersFrom(currModel);
                }
                ++i;
            }
        }

        private void _updateListeners(SelectionEvent event, boolean addListeners) {
            SelectionModel model = event.getSelectionModel();
            int startIndex = event.getStartIndex();
            int endIndex = startIndex + event.getItemCount();
            int i = startIndex;
            while (i < endIndex) {
                PropertyModel currModel = (PropertyModel)model.getSelectedItem(i);
                if (addListeners) {
                    this.addListenersTo(currModel);
                } else {
                    this.removeListenersFrom(currModel);
                }
                ++i;
            }
        }

        private void addListenersTo(PropertyModel model) {
            model.addTableModelListener(this);
            model.addPropertyChangeListener(this);
            model.setLocale(MultiObjectModel.this.getLocale());
            model.addPropertyModelListener(this);
        }

        private void removeListenersFrom(PropertyModel model) {
            model.removePropertyChangeListener(this);
            model.removeTableModelListener(this);
            model.removePropertyModelListener(this);
        }
    }
}

