/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.logging.ILoggingPage;
import oracle.dbtools.logging.LoggingController;
import oracle.dbtools.logging.TableCellWithTooltip;
import oracle.dbtools.logging.TableCellWithTooltipAndLevelIcon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.util.IdeUtil;

public class LoggingPage
extends AbstractLogPage
implements ILoggingPage {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private JTable _table;
    private DefaultTableModel _model;
    private JScrollPane _panel;
    private long _lastMills = 0L;
    private DefaultTableCellRenderer _renderer;

    public LoggingPage() {
        super(new ViewId("LoggingMessagePane", "Logging Page"), null, true);
    }

    public Component getGUI() {
        if (this._table == null) {
            this.initTable();
            this._panel = new JScrollPane(this._table);
            this._panel.setColumnHeaderView(this._table.getTableHeader());
            this._panel.setHorizontalScrollBarPolicy(32);
            this._panel.setVerticalScrollBarPolicy(20);
        }
        return this._panel;
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = LogManager.getLogManager().getContextMenu();
        return contextMenu;
    }

    private void initTable() {
        this._table = new JTable(this.getModel());
        this.getContextMenu().addContextMenuListener((ContextMenuListener)new LoggingController(this._table));
        this._renderer = new TableCellWithTooltip();
        this._table.setCellSelectionEnabled(false);
        this._table.setRowSelectionAllowed(true);
        this._table.setAutoResizeMode(0);
        this._table.getColumnModel().getColumn(0).setCellRenderer(new TableCellWithTooltipAndLevelIcon());
        this._table.getColumnModel().getColumn(1).setCellRenderer(this._renderer);
        this._table.getColumnModel().getColumn(2).setCellRenderer(this._renderer);
        this._table.getColumnModel().getColumn(3).setCellRenderer(this._renderer);
        this._table.getColumnModel().getColumn(4).setCellRenderer(this._renderer);
        this._table.getColumnModel().getColumn(0).setMaxWidth(20);
        this._table.getColumnModel().getColumn(0).setMaxWidth(40);
        this._table.getColumnModel().getColumn(1).setMaxWidth(59);
        this._table.getColumnModel().getColumn(2).setMaxWidth(70);
        this._table.getColumnModel().getColumn(0).setCellRenderer(new TableCellWithTooltipAndLevelIcon());
        this._table.getColumnModel().getColumn(1).setCellRenderer(this._renderer);
        this._table.getColumnModel().getColumn(2).setCellRenderer(this._renderer);
        this._table.getColumnModel().getColumn(3).setCellRenderer(this._renderer);
        this._table.getColumnModel().getColumn(4).setCellRenderer(this._renderer);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    LoggingPage.this.popupCurrentCell(mouseEvent.getPoint());
                } else if (mouseEvent.getButton() == 3) {
                    Context context = LoggingPage.this.getContext(mouseEvent);
                    context.setProperty("RSETTABLE", (Object)LoggingPage.this._table);
                    LoggingPage.this.getContextMenu().show(context);
                }
            }
        };
        this._table.addMouseListener(mouseAdapter);
    }

    public void clearAll() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this._table.getModel();
        for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
            defaultTableModel.removeRow(i);
        }
    }

    private DefaultTableModel getModel() {
        if (this._model == null) {
            this._model = new DefaultTableModel(){

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this._model.addColumn("Level");
            this._model.addColumn("Sequence");
            this._model.addColumn("Elapsed");
            this._model.addColumn("Source");
            this._model.addColumn("Message");
        }
        return this._model;
    }

    private void popupCurrentCell(Point point) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setMinimumSize(new Dimension(200, 200));
        JTextArea jTextArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jPanel.add((Component)jScrollPane, "Center");
        int n = this._table.rowAtPoint(point);
        int n2 = this._table.columnAtPoint(point);
        Object object = this._table.getValueAt(n, n2);
        jTextArea.setText(object == null ? "" : object.toString());
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)"Cell Value", (int)2);
        jEWTDialog.setMinimumSize(new Dimension(200, 200));
        jEWTDialog.setPreferredSize(new Dimension(200, 200));
        jEWTDialog.setSize(200, 200);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    protected void logMsg(Object object) {
        if (object instanceof LogRecord && Ide.isRunning()) {
            LogRecord logRecord = (LogRecord)object;
            Object[] objectArray = new Object[]{logRecord.getLevel() + "", logRecord.getSequenceNumber(), this._lastMills == 0L ? 0L : logRecord.getMillis() - this._lastMills, logRecord.getSourceClassName(), logRecord.getMessage() + ""};
            this.getModel().addRow(objectArray);
            this._lastMills = logRecord.getMillis();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Rectangle rectangle = LoggingPage.this._table.getCellRect(LoggingPage.this.getModel().getRowCount(), 0, true);
                    LoggingPage.this._table.scrollRectToVisible(rectangle);
                }
            });
        }
    }

    public void log(LogRecord logRecord) {
        this.log(logRecord, false);
    }
}

