/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatabasesFolderCache
extends HashStructureAdapter {
    private static final String DATA_KEY = "DatabaseFoldersCache";
    private static final String FOLDERS_KEY = "Folders";

    public static DatabasesFolderCache getInstance(PropertyStorage propertyStorage) {
        return new DatabasesFolderCache(DatabasesFolderCache.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    private DatabasesFolderCache(HashStructure hashStructure) {
        super(hashStructure);
    }

    private HashStructure getRootHash(boolean bl) {
        HashStructure hashStructure = this._hash.getHashStructure(FOLDERS_KEY);
        if (hashStructure == null && bl) {
            hashStructure = HashStructure.newInstance();
            this._hash.putHashStructure(FOLDERS_KEY, hashStructure);
        }
        return hashStructure;
    }

    private HashStructure getFolderHash(String string, boolean bl) {
        HashStructure hashStructure;
        String string2 = DatabasesFolderCache.encode(string);
        HashStructure hashStructure2 = this.getRootHash(bl);
        HashStructure hashStructure3 = hashStructure = hashStructure2 != null ? hashStructure2.getHashStructure(string2) : null;
        if (hashStructure == null && bl) {
            hashStructure = HashStructure.newInstance();
            hashStructure2.putHashStructure(string2, hashStructure);
        }
        return hashStructure;
    }

    public Set<String> getFolders(String string) {
        HashStructure hashStructure = this.getFolderHash(string, false);
        if (hashStructure != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string2 : hashStructure.keySet()) {
                hashSet.add(DatabasesFolderCache.decode(string2));
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getConnectionNames(String string, String string2) {
        ListStructure listStructure;
        HashStructure hashStructure = this.getFolderHash(string, false);
        if (hashStructure != null && (listStructure = hashStructure.getListStructure(DatabasesFolderCache.encode(string2))) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object = listStructure.iteratorLock();
            synchronized (object) {
                Iterator iterator = listStructure.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(DatabasesFolderCache.decode((String)iterator.next()));
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public void addFolder(String string, String string2) {
        HashStructure hashStructure = this.getFolderHash(string, true);
        if (hashStructure != null) {
            hashStructure.putListStructure(DatabasesFolderCache.encode(string2), ListStructure.newInstance());
        }
    }

    public void removeFolder(String string, String string2) {
        HashStructure hashStructure = this.getFolderHash(string, false);
        if (hashStructure != null) {
            hashStructure.remove(DatabasesFolderCache.encode(string2));
        }
    }

    public void renameFolder(String string, String string2, String string3) {
        String string4;
        ListStructure listStructure;
        HashStructure hashStructure = this.getFolderHash(string, false);
        if (hashStructure != null && (listStructure = hashStructure.getListStructure(string4 = DatabasesFolderCache.encode(string2))) != null) {
            hashStructure.remove(string4);
            hashStructure.putListStructure(DatabasesFolderCache.encode(string3), listStructure);
        }
    }

    public void addConnection(String string, String string2, String string3) {
        String string4;
        ListStructure listStructure = this.getConnectionList(string, string2);
        if (listStructure != null && !listStructure.contains((Object)(string4 = DatabasesFolderCache.encode(string3)))) {
            listStructure.add((Object)string4);
        }
    }

    private ListStructure getConnectionList(String string, String string2) {
        String string3 = DatabasesFolderCache.encode(string2);
        HashStructure hashStructure = this.getFolderHash(string, true);
        ListStructure listStructure = hashStructure.getListStructure(string3);
        if (listStructure == null) {
            listStructure = ListStructure.newInstance();
            hashStructure.putListStructure(string3, listStructure);
        }
        return listStructure;
    }

    public void removeConnection(String string, String string2, String string3) {
        ListStructure listStructure = this.getConnectionList(string, string2);
        if (listStructure != null) {
            listStructure.remove((Object)DatabasesFolderCache.encode(string3));
        }
    }

    private static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(DatabasesFolderCache.class.getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            return string;
        }
    }

    private static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(DatabasesFolderCache.class.getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            return string;
        }
    }
}

