/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.TreeSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.navigator.BaseNavigatorManager;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.folders.DatabasesFilter;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.folders.DatabasesFoldersController;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabasesFoldersMenuListener
implements ContextMenuListener {
    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (BaseNavigatorManager.isDatabaseNavigatorContext((Context)context)) {
            final Element[] elementArray = context.getSelection();
            if (DatabasesFoldersMenuListener.isValidSelectionOfType(elementArray, DatabaseConnection.class, true)) {
                TNode tNode;
                TNode tNode2;
                TNode tNode3 = ExplorerContext.getFirstTNode((Context)context);
                TNode tNode4 = (TNode)tNode3.getParent();
                if (tNode4.getData() instanceof Databases) {
                    tNode2 = tNode4;
                    tNode = null;
                } else {
                    tNode = tNode4;
                    tNode2 = (TNode)tNode4.getParent();
                }
                String string = tNode != null ? ((DatabasesFolder)tNode.getData()).getName() : null;
                IdeAction ideAction = IdeAction.find((int)DatabasesFoldersController.CONNECTION_CATEGORY_ID);
                JMenu jMenu = contextMenu.createSubMenu((String)ideAction.getValue("Name"), (Integer)ideAction.getValue("MnemonicKey"));
                JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)DatabasesFoldersController.NEW_CONNECTION_CATEGORY_ID));
                jMenu.add(jMenuItem);
                ChildFilter childFilter = tNode2.getChildFilter();
                if (childFilter instanceof DatabasesFilter) {
                    final DatabasesFilter databasesFilter = (DatabasesFilter)childFilter;
                    TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(databasesFilter.getFolderNames()));
                    if (string != null) {
                        treeSet.remove(string);
                    }
                    if (treeSet.size() > 0) {
                        jMenu.addSeparator();
                        for (final String string2 : treeSet) {
                            ToggleAction toggleAction = new ToggleAction(string2, null){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    databasesFilter.updateFolder(string2, elementArray);
                                }
                            };
                            jMenu.add(contextMenu.createMenuItem(toggleAction));
                        }
                    }
                }
                contextMenu.add((Component)jMenu, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
                ideAction = IdeAction.find((int)DatabasesFoldersController.REMOVE_FROM_FOLDER_ID);
                jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction);
                jMenuItem.setEnabled(string != null);
                contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
            } else if (DatabasesFoldersMenuListener.isValidSelectionOfType(elementArray, DatabasesFolder.class, false)) {
                IdeAction ideAction = IdeAction.find((int)DatabasesFoldersController.RENAME_CONNECTION_CATEGORY_ID);
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction), MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
                ideAction = IdeAction.find((int)DatabasesFoldersController.REMOVE_CONNECTION_CATEGORY_ID);
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction), MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
            }
        }
    }

    private static boolean isValidSelectionOfType(Element[] elementArray, Class<? extends Element> clazz, boolean bl) {
        if (elementArray != null && elementArray.length > 0 && (bl || elementArray.length == 1)) {
            for (Element element : elementArray) {
                if (clazz.isAssignableFrom(element.getClass())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

