/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class FolderNamePanel
extends DefaultTraversablePanel {
    static final String FOLDER_NAME_KEY = "FolderName";
    static final String OTHER_NAMES_KEY = "OtherFolderNames";
    private JTextField m_nameFld = new JTextField();
    private Set<String> m_names;
    private String m_origName;

    public FolderNamePanel() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_nameFld, (String)"&Folder Name:");
        this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_nameFld, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        String[] stringArray;
        super.onEntry(traversableContext);
        final DialogCallbacks dialogCallbacks = traversableContext.getDialogCallbacks();
        this.m_nameFld.getDocument().addDocumentListener(new DocumentListener(){

            private void validateName() {
                String string = FolderNamePanel.this.m_nameFld.getText();
                if (FolderNamePanel.this.m_origName != null && FolderNamePanel.this.m_origName.equals(string) || string == null || string.trim().length() == 0) {
                    dialogCallbacks.enableOKButton(false);
                } else {
                    dialogCallbacks.enableOKButton(true);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.validateName();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.validateName();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.validateName();
            }
        });
        String string = (String)traversableContext.find(FOLDER_NAME_KEY);
        if (string != null) {
            this.m_origName = string;
            this.m_nameFld.setText(string);
        }
        this.m_names = (stringArray = (String[])traversableContext.find(OTHER_NAMES_KEY)) != null ? new HashSet<String>(Arrays.asList(stringArray)) : Collections.emptySet();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        String string = this.m_nameFld.getText().trim();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException("Name must be specified");
        }
        if (ModelUtil.areEqual((Object)string, (Object)this.m_origName)) {
            throw new TraversalException("New name must be different");
        }
        if (this.m_names.contains(string)) {
            throw new TraversalException("Name is already in use");
        }
        traversableContext.put(FOLDER_NAME_KEY, (Object)string);
    }

    public String getHelpID() {
        return "f1_newconnfolder_html";
    }
}

