/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.folders.DatabasesFilter;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.folders.dnd.ConnectionDragHelper;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.util.dnd.DropHelper;

public class ConnectionDropHelper
implements DropHelper {
    public boolean canTransferData(Object object, DataFlavor[] dataFlavorArray, int n) {
        TNode tNode;
        return n == 2 && Arrays.asList(dataFlavorArray).contains(ConnectionDragHelper.CONN_NODE_FLAVOR) && (tNode = (TNode)object).getAncestor(Databases.class) != null;
    }

    public float getWeight() {
        return 10.0f;
    }

    public boolean transferData(Object object, Transferable[] transferableArray, int n) {
        TNode tNode = (TNode)object;
        DatabaseConnection databaseConnection = this.getConnectionNode(transferableArray);
        if (databaseConnection != null) {
            TNode tNode2 = tNode.getAncestorTNode(Databases.class, false);
            DatabasesFolder databasesFolder = (DatabasesFolder)tNode.getAncestor(DatabasesFolder.class, false);
            ChildFilter childFilter = tNode2.getChildFilter();
            if (childFilter instanceof DatabasesFilter) {
                DatabasesFilter databasesFilter = (DatabasesFilter)childFilter;
                if (databasesFolder == null) {
                    databasesFilter.updateFolder(null, new Element[]{databaseConnection});
                } else {
                    databasesFilter.updateFolder(databasesFolder.getName(), new Element[]{databaseConnection});
                }
                return true;
            }
        }
        return false;
    }

    private DatabaseConnection getConnectionNode(Transferable[] transferableArray) {
        for (Transferable transferable : transferableArray) {
            if (!transferable.isDataFlavorSupported(ConnectionDragHelper.CONN_NODE_FLAVOR)) continue;
            try {
                return (DatabaseConnection)transferable.getTransferData(ConnectionDragHelper.CONN_NODE_FLAVOR);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedFlavorException.getStackTrace()[0].toString(), unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        return null;
    }
}

