/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.ide.util.Version;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import oracle.dbtools.proformatter.ConfigProFormat;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.config.ConfigFormatChangeListener;
import oracle.dbtools.raptor.config.NonUserConfigOptions;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.standalone.ExtrasArb;
import oracle.dbtools.raptor.utils.URLChooserShortcuts;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ProductInformation;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.MenuItem;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.URLChooserShortcutProvider;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.adapter.DatabaseProviderClassLoaderFactory;
import oracle.jdevimpl.runner.debug.SharedActions;

public class RaptorStandaloneAddin
implements Addin {
    public void initialize() {
        if (RaptorExtensionConstants.isStandAlone()) {
            Menubar menubar = Ide.getMenubar();
            JMenu jMenu = MenuManager.getJMenu((String)"FileReopen");
            jMenu.getParent().remove(jMenu);
            Component component = menubar.getChildById((Container)MenuManager.getJMenu((String)"File"), IdeActions.getFileReloadNodesAction().getCommandId());
            component.getParent().remove(component);
            jMenu = MenuManager.getJMenu((String)"ViewOptions");
            jMenu.getParent().remove(jMenu);
            component = menubar.getGUI(true);
            JMenuBar jMenuBar = (JMenuBar)component;
            ContainerListener containerListener = new ContainerListener(){

                public void componentAdded(ContainerEvent containerEvent) {
                    containerEvent.getSource();
                    if (containerEvent.getSource() instanceof JPopupMenu && containerEvent.getChild() instanceof MenuItem) {
                        IdeAction ideAction = (IdeAction)((MenuItem)containerEvent.getChild()).getAction();
                        if (ideAction.getCommandId() == SharedActions.getInstance().getGcAction().getCommandId()) {
                            ((JPopupMenu)containerEvent.getSource()).remove(containerEvent.getChild());
                        } else if (ideAction.getCommand() != null && ideAction.getCommand().equals("tooltip-insight")) {
                            ((JPopupMenu)containerEvent.getSource()).remove(containerEvent.getChild());
                        }
                    }
                }

                public void componentRemoved(ContainerEvent containerEvent) {
                }
            };
            for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
                jMenu = jMenuBar.getMenu(i);
                jMenu.addContainerListener(containerListener);
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                jPopupMenu.addContainerListener(containerListener);
            }
            component = menubar.getGUI(true);
            if (NonUserConfigOptions.get((String)"raptor.user.agent.extras") != null) {
                ProductInformation.getProductInformation().setUserAgentExtras(NonUserConfigOptions.get((String)"raptor.user.agent.extras"));
            }
            ConfigProFormat.getInstance().addStructureChangeListener((StructureChangeListener)new ConfigFormatChangeListener());
            ConfigFormatChangeListener.setEditorTab();
            DialogUtil.addURLChooserShortcutProvider((URLChooserShortcutProvider)new URLChooserShortcuts());
            DatabaseProvider.setClassLoaderFactory((DatabaseProviderClassLoaderFactory)new DatabaseProviderClassLoaderFactory(){

                public ClassLoader getClassLoader(String string) {
                    return RaptorClassLoader.findClassLoader((String)string);
                }
            });
            final JavaVersion javaVersion = new JavaVersion();
            if (!javaVersion.isSupported()) {
                Ide.addIdeListener((IdeListener)new IdeListener(){

                    public void addinsLoaded(IdeEvent ideEvent) {
                    }

                    public void mainWindowClosing(IdeEvent ideEvent) {
                    }

                    public void mainWindowOpened(IdeEvent ideEvent) {
                        MessageDialog.critical(null, (Object)ExtrasArb.format(0, javaVersion.currentVersion(), javaVersion.minSupportedJava6Version(), javaVersion.minJava5Version()), (String)ExtrasArb.getString(1), null);
                    }
                });
            }
        }
    }

    private final class JavaVersion {
        private JavaVersion() {
        }

        String minUnsupportedJava6Version() {
            return "1.6";
        }

        String minSupportedJava6Version() {
            return "1.6.0_04";
        }

        String minJava5Version() {
            return System.getProperty("ide.java.minversion", this.defaultMinVersion());
        }

        private String defaultMinVersion() {
            return PlatformUtils.isWindows() ? "1.5.0_06" : "1.5.0";
        }

        String currentVersion() {
            return System.getProperty("java.version");
        }

        private Version normalizedMinUnsupportedJava6Version() {
            return this.normalize(this.minUnsupportedJava6Version());
        }

        private Version normalizedMinSupportedJava6Version() {
            return this.normalize(this.minSupportedJava6Version());
        }

        private Version normalizedCurrentVersion() {
            return this.normalize(this.currentVersion());
        }

        boolean isSupported() {
            Version version = this.normalizedMinUnsupportedJava6Version();
            Version version2 = this.normalizedMinSupportedJava6Version();
            Version version3 = this.normalizedCurrentVersion();
            boolean bl = version.compareTo(version3) > 0;
            boolean bl2 = version2.compareTo(version3) <= 0;
            return bl || bl2;
        }

        private Version normalize(String string) {
            string = string.trim();
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = null;
            boolean bl = true;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isDigit(c) || c == '.') {
                    if (stringBuilder2 == null) {
                        stringBuilder.append(c);
                        continue;
                    }
                    stringBuilder2.append(c);
                    continue;
                }
                if (stringBuilder2 != null) {
                    bl = false;
                    continue;
                }
                if (c != '_') continue;
                stringBuilder2 = new StringBuilder();
            }
            if (stringBuilder2 != null && bl) {
                stringBuilder.append('.');
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            return new Version(stringBuilder.toString());
        }
    }
}

