/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.conn.ResetPasswordPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.WindowsOSUtils;
import oracle.javatools.util.PlatformUtils;
import oracle.jdbc.OracleConnection;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.OracleConnectionCreator;

public class RaptorConnectionCreator
extends OracleConnectionCreator {
    private static Boolean isOCIDriverAvailable = null;
    private static String OCI_NEW_PASSWORD = "OCINewPassword";

    public Connection getConnection(Properties properties) throws SQLException {
        Connection connection = null;
        String string = properties.getProperty("user");
        String string2 = properties.getProperty("password");
        String string3 = properties.getProperty("customUrl");
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        Connections.populateConnectionInfo((Properties)properties2);
        String string4 = properties2.getProperty("customUrl");
        DBConfig dBConfig = DBConfig.getInstance();
        if (dBConfig.getBoolean("USE_THICK_DRIVER").booleanValue() && RaptorConnectionCreator.scrubOraDriverType(string4).equalsIgnoreCase("thin")) {
            properties2.setProperty("customUrl", this.getOCIUrl(properties2));
        }
        try {
            connection = super.getConnection(properties2);
            if (properties.get("IS_PROXY") != null && Boolean.parseBoolean(properties.getProperty("IS_PROXY"))) {
                this.openProxySession(connection, properties2);
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 28001) {
                if (this.resetPassword(properties2)) {
                    connection = super.getConnection(properties2);
                }
            }
            throw sQLException;
        }
        return connection;
    }

    protected boolean allowNullPassword() {
        return true;
    }

    private static String scrubOraDriverType(String string) {
        String string2 = "";
        if (string != null && string.startsWith("jdbc:oracle")) {
            String[] stringArray;
            int n = string.indexOf("@");
            String string3 = string.substring(0, n);
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if ((stringArray = string3.split(":")).length == 3) {
                string2 = stringArray[2];
            }
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean resetPassword(Properties properties) throws SQLException {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
        }
        if (isOCIDriverAvailable == null) {
            isOCIDriverAvailable = Connections.isOCIDriverAvailable();
        }
        if (!isOCIDriverAvailable.booleanValue()) throw new SQLException(CreateDialogArb.getString((int)589));
        ResetPasswordPanel.promptForNewPassword((Properties)properties);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        properties2.setProperty("customUrl", this.getOCIUrl(properties2));
        Connection connection = super.getConnection(properties2);
        if (connection == null) return false;
        properties.setProperty("password", properties.getProperty(OCI_NEW_PASSWORD));
        properties.remove(OCI_NEW_PASSWORD);
        try {
            DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
            String string = properties.getProperty("ConnName");
            databaseConnections.updateConnection(string, string, properties);
            return true;
        }
        catch (ConnectionException connectionException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, connectionException.getStackTrace()[0].toString(), connectionException);
        }
        return true;
    }

    protected void setCustomProperties(Properties properties, Properties properties2) {
        super.setCustomProperties(properties, properties2);
        String string = properties.getProperty("user");
        String string2 = properties.getProperty("password");
        String string3 = RaptorConnectionCreator.scrubOraDriverType(properties.getProperty("customUrl"));
        if (Boolean.parseBoolean(properties.getProperty("OS_AUTHENTICATION")) && PlatformUtils.isWindows() && string3.equalsIgnoreCase("thin")) {
            properties2.setProperty("v$session.osuser", WindowsOSUtils.getUserWithDomain());
        }
        if (properties.getProperty("OCINewPassword") != null) {
            properties2.setProperty("OCINewPassword", properties.getProperty("OCINewPassword"));
        }
    }

    private void openProxySession(Connection connection, Properties properties) throws SQLException {
        String string = properties.getProperty("PROXY_TYPE");
        Properties properties2 = new Properties();
        if (string.equals("USER NAME")) {
            String string2 = properties.getProperty("PROXY_USER_NAME");
            String string3 = properties.getProperty("PROXY_USER_PASSWORD");
            if (string3 != null && string3.length() > 0) {
                properties2.put("PROXY_USER_NAME", string2 + "/" + string3);
            } else {
                properties2.put("PROXY_USER_NAME", string2);
            }
            ((OracleConnection)connection).openProxySession(1, properties2);
        } else if (string.equals("DISTINGUISHED NAME")) {
            properties2.put("PROXY_USER_NAME", properties.getProperty("PROXY_USER_NAME"));
            properties2.put("PROXY_DISTINGUISHED_NAME", properties.getProperty("PROXY_DISTINGUISHED_NAME"));
            ((OracleConnection)connection).openProxySession(2, properties2);
        }
    }

    private String getThinUrl(Properties properties) throws SQLException {
        String string = properties.getProperty("customUrl");
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        if (this.hasLength(string)) {
            if (RaptorConnectionCreator.scrubOraDriverType(string).equals("oci8")) {
                properties2.setProperty("oraDriverType", "thin");
                properties2.remove("customUrl");
                return this.getConnectionURL(properties2);
            }
        } else {
            properties2.setProperty("oraDriverType", "thin");
            return this.getConnectionURL(properties2);
        }
        return string;
    }

    private String getOCIUrl(Properties properties) throws SQLException {
        String string = properties.getProperty("customUrl");
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        if (this.hasLength(string)) {
            if (RaptorConnectionCreator.scrubOraDriverType(string).equals("thin")) {
                properties2.setProperty("oraDriverType", "oci8");
                properties2.remove("customUrl");
                return this.getConnectionURL(properties2);
            }
        } else {
            properties2.setProperty("oraDriverType", "oci8");
            return this.getConnectionURL(properties2);
        }
        return string;
    }
}

