CREATE TABLE md_registry
        (
                object_type VARCHAR2(30) NOT NULL,
                object_name VARCHAR2(30) NOT NULL,
                CONSTRAINT md_registry_pk PRIMARY KEY(object_type, object_name) enable
        );
CREATE TABLE md_additional_properties
        (
                id                INTEGER NOT NULL          ,
                connection_id_fk  INTEGER NOT NULL          ,
                ref_id_fk         INTEGER NOT NULL          ,
                ref_type          VARCHAR2(4000) NOT NULL   ,
                property_order    INTEGER                   ,
                prop_key          VARCHAR2(4000) NOT NULL   ,
                VALUE             VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_additional_properties_pk PRIMARY KEY(id) enable
        );
CREATE TABLE migr_generation_order
        (
                id               INTEGER NOT NULL       ,
                connection_id_fk INTEGER NOT NULL       ,
                object_id        INTEGER NOT NULL       ,
                object_type      VARCHAR2(4000) NOT NULL,
                generation_order INTEGER NOT NULL       ,
                CONSTRAINT migr_generation_order_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_privileges
        (
                id                  INTEGER NOT NULL       ,
                schema_id_fk        INTEGER NOT NULL       ,
                privilege_name      VARCHAR2(4000) NOT NULL,
                privelege_object_id INTEGER                ,
                privelegeobjecttype VARCHAR2(4000) NOT NULL,
                privelege_type      VARCHAR2(4000) NOT NULL,
                admin_option CHARACTER(1)                  ,
                native_sql CLOB NOT NULL                   ,
                native_key        VARCHAR2(4000)                  ,
                comments          VARCHAR2(4000)                  ,
                security_group_id INTEGER DEFAULT 0 NOT NULL      ,
                created_on DATE DEFAULT sysdate NOT NULL          ,
                created_by VARCHAR2(255)                          ,
                last_updated_on DATE                              ,
                last_updated_by VARCHAR2(255)                     ,
                CONSTRAINT md_privileges_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_user_privileges
        (
                id                INTEGER NOT NULL          ,
                user_id_fk        INTEGER NOT NULL          ,
                privilege_id_fk   INTEGER                   ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_udpated_by VARCHAR2(255)               ,
                CONSTRAINT md_user_privileges_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_indexes
        (
                id          INTEGER NOT NULL                ,
                index_type  VARCHAR2(4000)                  ,
                table_id_fk INTEGER NOT NULL                ,
                index_name  VARCHAR2(4000)                  ,
                native_sql CLOB                             ,
                native_key        VARCHAR2(4000)            ,
                comments          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(4000)              ,
                CONSTRAINT md_indexes_pk PRIMARY KEY(id) enable
        );
CREATE TABLE migrlog
        (
                id            INTEGER NOT NULL,
                parent_log_id INTEGER         ,
                log_date TIMESTAMP NOT NULL   ,
                severity        NUMBER(4) NOT NULL   ,
                logtext         VARCHAR2(4000)       ,
                phase           VARCHAR2(20)         ,
                ref_object_id   INTEGER              ,
                ref_object_type VARCHAR2(4000)       ,
                CONSTRAINT migrlog_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_other_objects
        (
                id           INTEGER NOT NULL               ,
                schema_id_fk INTEGER NOT NULL               ,
                name         VARCHAR2(4000)                 ,
                native_sql CLOB                             ,
                native_key        VARCHAR2(4000)            ,
                comments          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_other_objects_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_user_defined_data_types
        (
                id             INTEGER NOT NULL       ,
                schema_id_fk   INTEGER NOT NULL       ,
                data_type_name VARCHAR2(4000) NOT NULL,
                definition     VARCHAR2(4000) NOT NULL,
                native_sql CLOB NOT NULL              ,
                native_key        VARCHAR2(4000)             ,
                comments          VARCHAR2(4000)             ,
                security_group_id INTEGER DEFAULT 0 NOT NULL ,
                created_on DATE DEFAULT sysdate NOT NULL     ,
                created_by VARCHAR2(255)                     ,
                last_updated_on DATE                         ,
                last_updated_by VARCHAR2(255)                ,
                CONSTRAINT md_user_defined_data_types_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_repoversions(revision INTEGER NOT NULL);
CREATE TABLE md_packages
        (
                id           INTEGER NOT NULL               ,
                schema_id_fk INTEGER NOT NULL               ,
                name         VARCHAR2(4000) NOT NULL        ,
                package_header CLOB                         ,
                native_sql CLOB                             ,
                native_key        VARCHAR2(4000)            ,
                LANGUAGE          VARCHAR2(40) NOT NULL     ,
                comments          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_packages_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_synonyms
        (
                id                 INTEGER NOT NULL       ,
                schema_id_fk       INTEGER NOT NULL       ,
                name               VARCHAR2(4000) NOT NULL,
                synonym_for_id     INTEGER NOT NULL       ,
                for_object_type    VARCHAR2(4000) NOT NULL,
                private_visibility CHAR(1)                ,
                native_sql CLOB                           ,
                native_key        VARCHAR2(4000)                 ,
                comments          VARCHAR2(4000)                 ,
                security_group_id INTEGER DEFAULT 0 NOT NULL     ,
                created_on DATE DEFAULT sysdate NOT NULL         ,
                created_by VARCHAR2(255)                         ,
                last_updated_on DATE                             ,
                last_updated_by VARCHAR2(255)                    ,
                CONSTRAINT md_synonyms_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_group_privileges
        (
                id                INTEGER NOT NULL          ,
                group_id_fk       INTEGER NOT NULL          ,
                privilege_id_fk   INTEGER NOT NULL          ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_group_privileges_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_migr_dependency
        (
                id                 INTEGER NOT NULL          ,
                connection_id_fk   INTEGER NOT NULL          ,
                parent_id          INTEGER NOT NULL          ,
                child_id           INTEGER NOT NULL          ,
                parent_object_type VARCHAR2(4000) NOT NULL   ,
                child_object_type  VARCHAR2(4000) NOT NULL   ,
                security_group_id  INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL     ,
                created_by VARCHAR2(255)                     ,
                last_updated_on DATE                         ,
                last_updated_by VARCHAR2(255)                ,
                CONSTRAINT migr_dependency_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_views
        (
                id           INTEGER NOT NULL               ,
                schema_id_fk INTEGER NOT NULL               ,
                view_name    VARCHAR2(4000)                 ,
                native_sql CLOB                             ,
                native_key        VARCHAR2(4000)            ,
                LANGUAGE          VARCHAR2(40) NOT NULL     ,
                comments          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_views_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_projects
        (
                id                INTEGER NOT NULL          ,
                project_name      VARCHAR2(4000) NOT NULL   ,
                comments          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_projects_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_columns
        (
                id            INTEGER NOT NULL       ,
                table_id_fk   INTEGER NOT NULL       ,
                column_name   VARCHAR2(4000) NOT NULL,
                column_order  INTEGER NOT NULL       ,
                column_type   VARCHAR2(4000)         ,
                PRECISION     INT                    ,
                scale         INT                    ,
                nullable      CHAR(1)                ,
                default_value VARCHAR2(4000)         ,
                native_sql CLOB                      ,
                native_key                VARCHAR2(4000)            ,
                datatype_transformed_flag CHAR(1)                   ,
                comments                  VARCHAR2(4000)            ,
                security_group_id         INTEGER DEFAULT 0 NOT NULL,
                created_by                VARCHAR2(255)             ,
                created_on DATE DEFAULT sysdate NOT NULL            ,
                last_updated_by VARCHAR2(255)                       ,
                last_updated_on DATE                                ,
                CONSTRAINT md_columns_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_group_members
        (
                id                 INTEGER NOT NULL          ,
                group_id_fk        INTEGER NOT NULL          ,
                user_id_fk         INTEGER                   ,
                group_member_id_fk INTEGER                   ,
                security_group_id  INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL     ,
                created_by VARCHAR2(255)                     ,
                last_updated_on DATE                         ,
                last_updated_by VARCHAR2(255)                ,
                CONSTRAINT md_group_members_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_users
        (
                id           INTEGER NOT NULL               ,
                schema_id_fk INTEGER NOT NULL               ,
                username     VARCHAR2(4000) NOT NULL        ,
                password     VARCHAR2(4000)                 ,
                native_sql CLOB                             ,
                native_key        VARCHAR2(4000)            ,
                comments          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_users_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_triggers
        (
                id                  INTEGER NOT NULL ,
                table_or_view_id_fk INTEGER NOT NULL ,
                trigger_on_flag CHARACTER(1) NOT NULL,
                trigger_name      VARCHAR2(4000)          ,
                trigger_timing    VARCHAR2(4000)          ,
                trigger_operation VARCHAR2(4000)          ,
                trigger_event     VARCHAR2(4000)          ,
                native_sql CLOB                           ,
                native_key        VARCHAR2(4000)                 ,
                LANGUAGE          VARCHAR2(40) NOT NULL          ,
                comments          VARCHAR2(4000)                 ,
                security_group_id INTEGER DEFAULT 0 NOT NULL     ,
                created_on DATE DEFAULT sysdate NOT NULL         ,
                created_by VARCHAR2(255)                         ,
                last_updated_on DATE                             ,
                last_updated_by VARCHAR2(255)                    ,
                CONSTRAINT md_triggers_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_tables
        (
                id           INTEGER NOT NULL                   ,
                schema_id_fk INTEGER NOT NULL                   ,
                TABLE_NAME   VARCHAR2(4000) NOT NULL            ,
                native_sql CLOB                                 ,
                native_key            VARCHAR2(4000)            ,
                qualified_native_name VARCHAR2(4000) NOT NULL   ,
                comments              VARCHAR2(4000)            ,
                security_group_id     INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL        ,
                created_by VARCHAR2(255)                        ,
                last_updated_on DATE                            ,
                last_updated_by VARCHAR2(255)                   ,
                CONSTRAINT md_tables_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_groups
        (
                id           INTEGER NOT NULL               ,
                schema_id_fk INTEGER NOT NULL               ,
                group_name   VARCHAR2(4000)                 ,
                group_flag   CHAR(1)                        ,
                native_sql CLOB                             ,
                native_key        VARCHAR2(4000)            ,
                comments          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_groups_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_stored_programs
        (
                id            INTEGER NOT NULL              ,
                schema_id_fk  INTEGER NOT NULL              ,
                programtype   VARCHAR2(20)                  ,
                name          VARCHAR2(4000)                ,
                package_id_fk INTEGER                       ,
                native_sql CLOB                             ,
                native_key        VARCHAR2(4000)            ,
                LANGUAGE          VARCHAR2(40) NOT NULL     ,
                comments          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)
        );
CREATE TABLE md_migr_weakdep
        (
                id                INTEGER NOT NULL         ,
                connection_id_fk  INTEGER NOT NULL         ,
                schema_id_fk      INTEGER NOT NULL         ,
                parent_id         INTEGER NOT NULL         ,
                child_name        VARCHAR2(4000) NOT NULL  ,
                parent_type       VARCHAR2(4000) NOT NULL  ,
                child_type        VARCHAR2(4000) NOT NULL  ,
                security_group_id NUMBER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL   ,
                created_by VARCHAR2(255)                   ,
                last_updated_on DATE                       ,
                last_updated_by VARCHAR2(255)              ,
                CONSTRAINT migr_weakdep_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_constraint_details
        (
                id               INTEGER NOT NULL           ,
                ref_flag         CHAR(1) DEFAULT 'N'        ,
                constraint_id_fk INTEGER NOT NULL           ,
                column_id_fk     INTEGER                    ,
                column_portion   INTEGER                    ,
                constraint_text CLOB                        ,
                detail_order      INTEGER NOT NULL          ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_constraint_details_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_sequences
        (
                id           INTEGER NOT NULL         ,
                schema_id_fk INTEGER NOT NULL         ,
                name         VARCHAR2(4000) NOT NULL  ,
                seq_start    NUMBER NOT NULL          ,
                incr         NUMBER DEFAULT 1 NOT NULL,
                native_sql CLOB                       ,
                native_key        VARCHAR2(4000)             ,
                comments          VARCHAR2(4000)             ,
                security_group_id INTEGER DEFAULT 0 NOT NULL ,
                created_on DATE DEFAULT sysdate NOT NULL     ,
                created_by VARCHAR2(255) DEFAULT '0' NOT NULL,
                last_updated_on DATE                         ,
                last_updated_by VARCHAR2(255)                ,
                CONSTRAINT md_sequences_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_migr_parameter
        (
                id                INTEGER NOT NULL          ,
                connection_id_fk  INTEGER NOT NULL          ,
                object_id         INTEGER NOT NULL          ,
                object_type       VARCHAR2(4000) NOT NULL   ,
                param_existing    SMALLINT NOT NULL         ,
                param_order       INTEGER NOT NULL          ,
                param_name        VARCHAR2(4000) NOT NULL   ,
                param_type        VARCHAR2(4000) NOT NULL   ,
                param_data_type   VARCHAR2(4000) NOT NULL   ,
                percision         INTEGER                   ,
                scale             INTEGER                   ,
                nullable          CHAR(1) NOT NULL          ,
                default_value     VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR(255)                     ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT migr_parameter_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_catalogs
        (
                id               INTEGER NOT NULL           ,
                connection_id_fk INTEGER NOT NULL           ,
                catalog_name     VARCHAR2(4000)             ,
                dummy_flag       CHAR(1) DEFAULT 'N'        ,
                native_sql CLOB                             ,
                native_key        VARCHAR2(4000)            ,
                comments          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_catalogs_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_tablespaces
        (
                id              INTEGER NOT NULL            ,
                schema_id_fk    INTEGER NOT NULL            ,
                tablespace_name VARCHAR2(4000)              ,
                native_sql CLOB                             ,
                native_key        VARCHAR2(4000)            ,
                comments          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_tablespaces_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_index_details
        (
                id                INTEGER NOT NULL          ,
                index_id_fk       INTEGER NOT NULL          ,
                column_id_fk      INTEGER NOT NULL          ,
                index_portion     INT                       ,
                detail_order      INTEGER NOT NULL          ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_index_details_pk PRIMARY KEY(id) enable
        );
CREATE TABLE migr_datatype_transform_map
        (
                id                INTEGER NOT NULL          ,
                project_id_fk     INTEGER NOT NULL          ,
                map_name          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT migr_datatype_transform_m_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_constraints
        (
                id              INTEGER NOT NULL            ,
                delete_clause   VARCHAR2(4000)              ,
                name            VARCHAR2(4000)              ,
                constraint_type VARCHAR2(4000)              ,
                table_id_fk     INTEGER NOT NULL            ,
                reftable_id_fk  INTEGER                     ,
                constraint_text CLOB                        ,
                LANGUAGE          VARCHAR2(40) NOT NULL     ,
                comments          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_constraints_pk PRIMARY KEY(id) enable
        );
CREATE TABLE migr_datatype_transform_rule
        (
                id                    INTEGER NOT NULL          ,
                map_id_fk             INTEGER NOT NULL          ,
                source_data_type_name VARCHAR2(4000) NOT NULL   ,
                source_precision      NUMBER                    ,
                source_scale          NUMBER                    ,
                target_data_type_name VARCHAR2(4000) NOT NULL   ,
                target_precision      NUMBER                    ,
                target_scale          NUMBER                    ,
                security_group_id     INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL        ,
                created_by VARCHAR2(255)                        ,
                last_updated_on DATE                            ,
                last_updated_by VARCHAR2(255)                   ,
                CONSTRAINT migr_datatype_transform_r_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_derivatives
        (
                id                       INTEGER NOT NULL          ,
                src_id                   INTEGER NOT NULL          ,
                src_type                 VARCHAR2(4000)            ,
                derived_id               INTEGER NOT NULL          ,
                derived_type             VARCHAR2(4000)            ,
                derived_connection_id_fk INTEGER NOT NULL          ,
                transformed              CHAR(1)                   ,
                original_identifier      VARCHAR2(4000)            ,
                new_identifier           VARCHAR2(4000)            ,
                derived_object_namespace VARCHAR2(40)              ,
                derivative_reason        VARCHAR2(10)              ,
                security_group_id        INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL           ,
                created_by VARCHAR2(255)                           ,
                last_updated_on DATE                               ,
                last_updated_by VARCHAR2(255)                      ,
                CONSTRAINT migrdreivatives_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_connections
        (
                id            INTEGER NOT NULL                        ,
                project_id_fk INTEGER NOT NULL                        ,
                type          VARCHAR2(4000)                          ,
                host          VARCHAR2(4000)                          ,
                port          INT                                     ,
                username      VARCHAR2(4000)                          ,
                password      VARCHAR2(4000)                          ,
                dburl         VARCHAR2(4000)                          ,
                name          VARCHAR2(255)                           ,
                native_sql CLOB                                       ,
                num_catalogs                INTEGER                   ,
                num_columns                 INTEGER                   ,
                num_constraints             INTEGER                   ,
                num_groups                  INTEGER                   ,
                num_roles                   INTEGER                   ,
                num_indexes                 INTEGER                   ,
                num_other_objects           INTEGER                   ,
                num_packages                INTEGER                   ,
                num_privileges              INTEGER                   ,
                num_schemas                 INTEGER                   ,
                num_sequences               INTEGER                   ,
                num_stored_programs         INTEGER                   ,
                num_synonyms                INTEGER                   ,
                num_tables                  INTEGER                   ,
                num_tablespaces             INTEGER                   ,
                num_triggers                INTEGER                   ,
                num_user_defined_data_types INTEGER                   ,
                num_users                   INTEGER                   ,
                num_views                   INTEGER                   ,
                comments                    VARCHAR2(4000)            ,
                security_group_id           INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL              ,
                created_by VARCHAR2(255)                              ,
                last_updated_on DATE                                  ,
                last_updated_by VARCHAR2(255)                         ,
                CONSTRAINT md_connections_pk PRIMARY KEY(id) enable
        );
CREATE TABLE md_schemas
        (
                id            INTEGER NOT NULL              ,
                catalog_id_fk INTEGER NOT NULL              ,
                name          VARCHAR2(4000)                ,
                type          CHAR(1)                       ,
                character_set VARCHAR2(4000)                ,
                version_tag   VARCHAR2(40)                  ,
                native_sql CLOB                             ,
                native_key        VARCHAR2(4000)            ,
                comments          VARCHAR2(4000)            ,
                security_group_id INTEGER DEFAULT 0 NOT NULL,
                created_on DATE DEFAULT sysdate NOT NULL    ,
                created_by VARCHAR2(255)                    ,
                last_updated_on DATE                        ,
                last_updated_by VARCHAR2(255)               ,
                CONSTRAINT md_schemas_pk PRIMARY KEY(id) enable
        );
ALTER TABLE md_additional_properties ADD CONSTRAINT md_additional_properties__fk1 FOREIGN KEY(connection_id_fk) REFERENCES md_connections(id) ON
DELETE cascade enable;
ALTER TABLE migr_generation_order ADD CONSTRAINT migr_generation_order_md__fk1 FOREIGN KEY(connection_id_fk) REFERENCES md_connections(id) ON
DELETE cascade enable;
ALTER TABLE md_privileges ADD CONSTRAINT md_privileges_md_schemas_fk1 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_user_privileges ADD CONSTRAINT md_user_privileges_md_use_fk1 FOREIGN KEY(user_id_fk) REFERENCES md_users(id) ON
DELETE cascade enable;
ALTER TABLE md_user_privileges ADD CONSTRAINT md_user_privileges_md_pri_fk1 FOREIGN KEY(privilege_id_fk) REFERENCES md_privileges(id) ON
DELETE cascade enable;
ALTER TABLE md_indexes ADD CONSTRAINT md_indexes_md_tables_fk1 FOREIGN KEY(table_id_fk) REFERENCES md_tables(id) ON
DELETE cascade enable;
ALTER TABLE migrlog ADD CONSTRAINT migr_migrlog_fk FOREIGN KEY(parent_log_id) REFERENCES migrlog(id) enable;
ALTER TABLE md_other_objects ADD CONSTRAINT md_other_objects_md_schem_fk1 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_user_defined_data_types ADD CONSTRAINT md_user_defined_data_type_fk1 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_packages ADD CONSTRAINT md_packages_md_schemas_fk1 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_synonyms ADD CONSTRAINT md_synonyms_md_schemas_fk1 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_group_privileges ADD CONSTRAINT md_group_privileges_md_gr_fk1 FOREIGN KEY(group_id_fk) REFERENCES md_groups(id) ON
DELETE cascade enable;
ALTER TABLE md_group_privileges ADD CONSTRAINT md_group_privileges_md_pr_fk1 FOREIGN KEY(privilege_id_fk) REFERENCES md_privileges(id) ON
DELETE cascade enable;
ALTER TABLE md_migr_dependency ADD CONSTRAINT migr_dependency_fk FOREIGN KEY(connection_id_fk) REFERENCES md_connections(id) ON
DELETE cascade enable;
ALTER TABLE md_views ADD CONSTRAINT md_views_md_schemas_fk1 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_columns ADD CONSTRAINT md_columns_md_tables_fk1 FOREIGN KEY(table_id_fk) REFERENCES md_tables(id) ON
DELETE cascade enable;
ALTER TABLE md_group_members ADD CONSTRAINT md_groupmembers_md_groups_fk1 FOREIGN KEY(group_id_fk) REFERENCES md_groups(id) ON
DELETE cascade enable;
ALTER TABLE md_group_members ADD CONSTRAINT md_groupmembers_md_users_fk1 FOREIGN KEY(user_id_fk) REFERENCES md_users(id) ON
DELETE cascade enable;
ALTER TABLE md_group_members ADD CONSTRAINT md_groupmembers_md_groups_fk2 FOREIGN KEY(group_member_id_fk) REFERENCES md_groups(id) ON
DELETE cascade enable;
ALTER TABLE md_users ADD CONSTRAINT md_users_md_schemas_fk1 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_tables ADD CONSTRAINT md_tables_md_schemas_fk1 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_groups ADD CONSTRAINT md_groups_md_schemas_fk1 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_stored_programs ADD CONSTRAINT md_stored_programs_md_pac_fk1 FOREIGN KEY(package_id_fk) REFERENCES md_packages(id) ON
DELETE cascade enable;
ALTER TABLE md_stored_programs ADD CONSTRAINT md_stored_programs_md_sch_fk1 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_migr_weakdep ADD CONSTRAINT migr_weakdep_fk1 FOREIGN KEY(connection_id_fk) REFERENCES md_connections(id) ON
DELETE cascade enable;
ALTER TABLE md_migr_weakdep ADD CONSTRAINT migr_weakdep_fk2 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_constraint_details ADD CONSTRAINT md_constraint_details_md__fk1 FOREIGN KEY(constraint_id_fk) REFERENCES md_constraints(id) ON
DELETE cascade enable;
ALTER TABLE md_constraint_details ADD CONSTRAINT md_constraint_details_md__fk2 FOREIGN KEY(column_id_fk) REFERENCES md_columns(id) ON
DELETE cascade enable;
ALTER TABLE md_sequences ADD CONSTRAINT md_sequences_md_schemas_fk1 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_migr_parameter ADD CONSTRAINT migr_parameter_fk FOREIGN KEY(connection_id_fk) REFERENCES md_connections(id) ON
DELETE cascade enable;
ALTER TABLE md_catalogs ADD CONSTRAINT md_catalogs_md_connection_fk1 FOREIGN KEY(connection_id_fk) REFERENCES md_connections(id) ON
DELETE cascade enable;
ALTER TABLE md_tablespaces ADD CONSTRAINT md_tablespaces_md_schemas_fk1 FOREIGN KEY(schema_id_fk) REFERENCES md_schemas(id) ON
DELETE cascade enable;
ALTER TABLE md_index_details ADD CONSTRAINT md_index_details_md_colum_fk1 FOREIGN KEY(column_id_fk) REFERENCES md_columns(id) ON
DELETE cascade enable;
ALTER TABLE md_index_details ADD CONSTRAINT md_index_details_md_index_fk1 FOREIGN KEY(index_id_fk) REFERENCES md_indexes(id) ON
DELETE cascade enable;
ALTER TABLE migr_datatype_transform_map ADD CONSTRAINT migr_datatype_transform_m_fk1 FOREIGN KEY(project_id_fk) REFERENCES md_projects(id) ON
DELETE cascade enable;
ALTER TABLE md_constraints ADD CONSTRAINT md_constraints_md_tables_fk1 FOREIGN KEY(table_id_fk) REFERENCES md_tables(id) ON
DELETE cascade enable;
ALTER TABLE migr_datatype_transform_rule ADD CONSTRAINT migr_datatype_transform_r_fk1 FOREIGN KEY(map_id_fk) REFERENCES migr_datatype_transform_map(id) ON
DELETE cascade enable;
ALTER TABLE md_derivatives ADD CONSTRAINT md_derivatives_md_connect_fk1 FOREIGN KEY(derived_connection_id_fk) REFERENCES md_connections(id) ON
DELETE cascade enable;
ALTER TABLE md_connections ADD CONSTRAINT md_connections_md_project_fk1 FOREIGN KEY(project_id_fk) REFERENCES md_projects(id) ON
DELETE cascade enable;
ALTER TABLE md_schemas ADD CONSTRAINT md_schemas_md_catalogs_fk1 FOREIGN KEY(catalog_id_fk) REFERENCES md_catalogs(id) ON
DELETE cascade enable;
CREATE OR REPLACE VIEW mgv_all_views
AS
        SELECT  md_projects.id project_id            ,
                md_projects.project_name project_name,
                md_connections.id connection_id      ,
                md_connections.host host             ,
                md_connections.port port             ,
                username username                    ,
                md_catalogs.id catalog_id            ,
                md_catalogs.catalog_name catalog_name,
                md_catalogs.dummy_flag dummy_flag    ,
                md_schemas.id schema_id              ,
                md_schemas.name schema_name          ,
                md_views.id view_id                  ,
                md_views.view_name view_name
        FROM    md_projects   ,
                md_connections,
                md_catalogs   ,
                md_schemas    ,
                md_views
        WHERE   md_views.schema_id_fk        = md_schemas.id
            AND md_schemas.catalog_id_fk     = md_catalogs.id
            AND md_catalogs.connection_id_fk = md_connections.id
            AND md_connections.project_id_fk = md_projects.id WITH READ ONLY;
CREATE OR REPLACE VIEW mgv_all_tables
AS
        SELECT  md_projects.id project_id            ,
                md_projects.project_name project_name,
                md_connections.id connection_id      ,
                md_connections.host host             ,
                md_connections.port port             ,
                md_connections.username username     ,
                md_connections.dburl dburl           ,
                md_catalogs.id catalog_id            ,
                md_catalogs.catalog_name catalog_name,
                md_schemas.id schema_id              ,
                md_schemas.name schema_name          ,
                md_tables.id table_id                ,
                md_tables.TABLE_NAME TABLE_NAME
        FROM    md_connections,
                md_catalogs   ,
                md_schemas    ,
                md_tables     ,
                md_projects
        WHERE   md_tables.schema_id_fk       = md_schemas.id
            AND md_schemas.catalog_id_fk     = md_catalogs.id
            AND md_catalogs.connection_id_fk = md_connections.id
            AND md_connections.project_id_fk = md_projects.id WITH READ ONLY;
CREATE OR REPLACE VIEW mgv_all_view_triggers
AS
        SELECT  md_projects.id project_id            ,
                md_projects.project_name project_name,
                md_connections.id connection_id      ,
                md_connections.host host             ,
                md_connections.port port             ,
                md_connections.username username     ,
                md_catalogs.id catalog_id            ,
                md_catalogs.catalog_name catalog_name,
                md_catalogs.dummy_flag dummy_flag    ,
                md_schemas.id schema_id              ,
                md_schemas.name schema_name          ,
                md_views.id view_id                  ,
                md_views.view_name view_name         ,
                md_triggers.id trigger_id            ,
                md_triggers.trigger_name trigger_name
        FROM    md_projects   ,
                md_connections,
                md_catalogs   ,
                md_schemas    ,
                md_views      ,
                md_triggers
        WHERE   md_triggers.table_or_view_id_fk = md_views.id
            AND md_views.schema_id_fk           = md_schemas.id
            AND md_schemas.catalog_id_fk        = md_catalogs.id
            AND md_catalogs.connection_id_fk    = md_connections.id
            AND md_connections.project_id_fk    = md_projects.id;
CREATE OR REPLACE VIEW mgv_all_connections
AS
        SELECT  md_projects.id project_id            ,
                md_projects.project_name project_name,
                md_connections.id connection_id      ,
                md_connections.host host             ,
                md_connections.port port             ,
                md_connections.username username     ,
                md_connections.dburl dburl
        FROM    md_projects,
                md_connections
        WHERE   md_connections.project_id_fk = md_projects.id WITH READ ONLY;
CREATE OR REPLACE VIEW mgv_all_schema
AS
        SELECT  md_projects.id project_id            ,
                md_projects.project_name project_name,
                md_connections.id connection_id      ,
                md_connections.host host             ,
                md_connections.port port             ,
                md_connections.username username     ,
                md_catalogs.id catalog_id            ,
                md_catalogs.catalog_name catalog_name,
                md_schemas.id schema_id              ,
                md_schemas.name schema_name
        FROM    md_connections,
                md_catalogs   ,
                md_schemas    ,
                md_projects
        WHERE   md_schemas.catalog_id_fk     = md_catalogs.id
            AND md_catalogs.connection_id_fk = md_connections.id
            AND md_connections.project_id_fk = md_projects.id WITH READ ONLY;
CREATE OR REPLACE VIEW mgv_all_table_triggers
AS
        SELECT  md_projects.id project_id            ,
                md_projects.project_name project_name,
                md_connections.id connection_id      ,
                md_connections.host host             ,
                md_connections.port port             ,
                md_connections.username username     ,
                md_catalogs.id catalog_id            ,
                md_catalogs.catalog_name catalog_name,
                md_catalogs.dummy_flag dummy_flag    ,
                md_schemas.id schema_id              ,
                md_schemas.name schema_name          ,
                md_tables.id table_id                ,
                md_tables.TABLE_NAME TABLE_NAME      ,
                md_triggers.id trigger_id            ,
                md_triggers.trigger_name trigger_name
        FROM    md_projects   ,
                md_connections,
                md_catalogs   ,
                md_schemas    ,
                md_tables     ,
                md_triggers
        WHERE   md_triggers.table_or_view_id_fk = md_tables.id
            AND md_tables.schema_id_fk          = md_schemas.id
            AND md_schemas.catalog_id_fk        = md_catalogs.id
            AND md_catalogs.connection_id_fk    = md_connections.id
            AND md_connections.project_id_fk    = md_projects.id;
CREATE OR REPLACE VIEW mgv_all_stored_programs
AS
        SELECT  md_projects.id project_id                  ,
                md_projects.project_name project_name      ,
                md_connections.id connection_id            ,
                md_connections.host host                   ,
                md_connections.port port                   ,
                md_connections.username username           ,
                md_catalogs.id catalog_id                  ,
                md_catalogs.catalog_name catalog_name      ,
                md_schemas.id schema_id                    ,
                md_schemas.name schema_name                ,
                md_stored_programs.id stored_program_id    ,
                md_stored_programs.programtype programtype ,
                md_stored_programs.name stored_program_name,
                md_stored_programs.package_id_fk package_id_fk
        FROM    md_projects   ,
                md_connections,
                md_catalogs   ,
                md_schemas    ,
                md_stored_programs
        WHERE   md_stored_programs.schema_id_fk = md_schemas.id
            AND md_schemas.catalog_id_fk        = md_catalogs.id
            AND md_catalogs.connection_id_fk    = md_connections.id
            AND md_connections.project_id_fk    = md_projects.id;
CREATE OR REPLACE VIEW mgv_all_catalogs
AS
        SELECT  md_projects.id project_id            ,
                md_projects.project_name project_name,
                md_connections.id connection_id      ,
                md_connections.host host             ,
                md_connections.port port             ,
                md_connections.username username     ,
                md_connections.dburl dburl           ,
                md_catalogs.id catalog_id            ,
                md_catalogs.catalog_name catalog_name
        FROM    md_projects   ,
                md_connections,
                md_catalogs
        WHERE   md_catalogs.connection_id_fk = md_connections.id
            AND md_connections.project_id_fk = md_projects.id WITH READ ONLY;
COMMENT ON TABLE md_registry
IS
         'Table to store information on the MD_ repository.  This lists the objects to be dropped if you wish to remove the repository';
COMMENT ON TABLE mgv_all_views
IS
         'View to iterate over all views in the system';
COMMENT ON TABLE md_additional_properties
IS
         'This table is used to store additional properties in key-value pairs.  It is designed to store "other information" that is not supported in the main database object table.';
COMMENT ON TABLE md_privileges
IS
         'This table stores privilege information';
COMMENT ON TABLE md_user_privileges
IS
         'This table stores privileges granted to individual users';
COMMENT ON TABLE md_indexes
IS
         'This table is used to store information about the indexes in a schema';
COMMENT ON TABLE md_other_objects
IS
         'For storing objects that don''t belong anywhere else';
COMMENT ON TABLE md_user_defined_data_types
IS
         'For sotring information on user defined data types.';
COMMENT ON TABLE md_repoversions
IS
         'This table is used to version this schema for future requirements.';
COMMENT ON TABLE md_packages
IS
         'For storing packages';
COMMENT ON TABLE md_synonyms
IS
         'For storing synonym information.';
COMMENT ON TABLE md_group_privileges
IS
         'This table stores the privileges granted to a group (or role)';
COMMENT ON TABLE md_views
IS
         'For storing information on views.';
COMMENT ON TABLE md_projects
IS
         'This is a top level container for a set of connections.';
COMMENT ON TABLE md_columns
IS
         'Column information is stored in this table.';
COMMENT ON TABLE md_group_members
IS
         'This table is used to store the members of a group.';
COMMENT ON TABLE md_users
IS
         'User information.';
COMMENT ON TABLE md_triggers
IS
         'For storing information about triggers.';
COMMENT ON TABLE md_tables
IS
         'Table used to store information about tables.';
COMMENT ON TABLE md_groups
IS
         'Groups of users in a schema';
COMMENT ON TABLE md_stored_programs
IS
         'Container for stored programs.';
COMMENT ON TABLE md_constraint_details
IS
         'Constraint details show what columns are "involved" in a constraint.';
COMMENT ON TABLE md_sequences
IS
         'For storing information on sequences.';
COMMENT ON TABLE md_catalogs
IS
         'Store catalogs in this table.';
COMMENT ON TABLE md_tablespaces
IS
         'For storing information about tablespaces.';
COMMENT ON TABLE md_index_details
IS
         'This table stores the details of an index.  It shows what columns are "part" of the index.';
COMMENT ON TABLE migr_datatype_transform_map
IS
         'Table for storing data type maps.  A map is simply a collection of rules';
COMMENT ON TABLE md_constraints
IS
         'Table for storing information about a constraint';
COMMENT ON TABLE md_derivatives
IS
         'This table is used to store objects that are derived from each other.  For example in a migration an auto-increment column in a source model could be mapped to a primary key, and a sequence, and a trigger.  The MD_DERIVATIVES table would store the fact that these 3 objects are derived from the auto-increment column.';
COMMENT ON TABLE md_connections
IS
         'This table is used to store connection information.  For example, in migrations, we could be carrying out a consolidation which occurs across many connections.';
COMMENT ON TABLE md_schemas
IS
         'This is the holder for schemas';
COMMENT ON COLUMN md_additional_properties.id
IS
         'Primary Key';
COMMENT ON COLUMN md_additional_properties.connection_id_fk
IS
         'Connection to which this belongs //PARENTFIELD';
COMMENT ON COLUMN md_additional_properties.ref_id_fk
IS
         'The object to which this property blongs';
COMMENT ON COLUMN md_additional_properties.ref_type
IS
         'Type of object that this property belongs to';
COMMENT ON COLUMN md_additional_properties.property_order
IS
         'This is to handle a situation where multiple properties have a relevant order, or multiple properties have multiple values';
COMMENT ON COLUMN md_additional_properties.prop_key
IS
         'The keyname for this property';
COMMENT ON COLUMN md_additional_properties.VALUE
IS
         'The value for this property';
COMMENT ON COLUMN migr_generation_order.connection_id_fk
IS '//PARENTFIELD';
COMMENT ON COLUMN md_privileges.id
IS
         'Primary Key';
COMMENT ON COLUMN md_privileges.schema_id_fk
IS
         'The schema to which this object belongs //PARENTFIELD';
COMMENT ON COLUMN md_privileges.privilege_name
IS
         'The name of the privilege //OBJECTNAME';
COMMENT ON COLUMN md_privileges.privelege_object_id
IS
         'This references the table, view, etc on which the privelege exists.  This can be NULL for things like system wide privileges';
COMMENT ON COLUMN md_privileges.privelegeobjecttype
IS
         'The type the privelege is on (e.g. INDEX)';
COMMENT ON COLUMN md_privileges.privelege_type
IS
         'e.g.select';
COMMENT ON COLUMN md_privileges.admin_option
IS
         'Flag to show if this was granted with admin option.  ''Y'' means it was granted with admin option ''N'' means it was NOT granted with admin option.  NULL means not applicable (e.g. not known, not supported by source platform, etc.)';
COMMENT ON COLUMN md_privileges.native_sql
IS
         'The SQL used to create this privilege at source';
COMMENT ON COLUMN md_privileges.native_key
IS
         'An identifier for this object at source.';
COMMENT ON COLUMN md_user_privileges.id
IS
         'Primary Key';
COMMENT ON COLUMN md_user_privileges.user_id_fk
IS
         'User';
COMMENT ON COLUMN md_user_privileges.privilege_id_fk
IS
         'Privilege';
COMMENT ON COLUMN md_indexes.id
IS
         'Primary Key';
COMMENT ON COLUMN md_indexes.index_type
IS
         'Type of the index e.g. PRIMARY';
COMMENT ON COLUMN md_indexes.table_id_fk
IS
         'Table that this index is on //PARENTFIELD';
COMMENT ON COLUMN md_indexes.index_name
IS
         'Name of the index //OBJECTNAME';
COMMENT ON COLUMN md_indexes.native_sql
IS
         'SQL used to create the index at source';
COMMENT ON COLUMN md_indexes.native_key
IS
         'A unique identifier for this object at the source';
COMMENT ON COLUMN md_other_objects.id
IS
         'Primary Key';
COMMENT ON COLUMN md_other_objects.schema_id_fk
IS
         'Schema to which this object blongs. //PARENTFIELD';
COMMENT ON COLUMN md_other_objects.name
IS
         'Name of this object //OBJECTNAME';
COMMENT ON COLUMN md_other_objects.native_sql
IS
         'The native SQL used to create this object';
COMMENT ON COLUMN md_other_objects.native_key
IS
         'A key that identifies this object at source.';
COMMENT ON COLUMN md_user_defined_data_types.id
IS
         'Primary Key';
COMMENT ON COLUMN md_user_defined_data_types.schema_id_fk
IS
         'Schema to which this object blongs. //PARENTFIELD';
COMMENT ON COLUMN md_user_defined_data_types.data_type_name
IS
         'The name of the data type //OBJECTNAME';
COMMENT ON COLUMN md_user_defined_data_types.definition
IS
         'The definition of the data type';
COMMENT ON COLUMN md_user_defined_data_types.native_sql
IS
         'The native SQL used to create this object';
COMMENT ON COLUMN md_user_defined_data_types.native_key
IS
         'An unique identifier for this object at source.';
COMMENT ON COLUMN md_packages.id
IS
         'Primary Key';
COMMENT ON COLUMN md_packages.schema_id_fk
IS
         'the schema in which this package resides //PARENTFIELD';
COMMENT ON COLUMN md_packages.name
IS
         'Name of this package //OBJECTNAME';
COMMENT ON COLUMN md_packages.native_sql
IS
         'The SQL used to create this package at source';
COMMENT ON COLUMN md_packages.native_key
IS
         'A unique identifer for this object at source.';
COMMENT ON COLUMN md_packages.LANGUAGE
IS '//PUBLIC';
COMMENT ON COLUMN md_synonyms.id
IS
         'Primary Key';
COMMENT ON COLUMN md_synonyms.schema_id_fk
IS
         'The schema to which this object belongs //PARENTFIELD';
COMMENT ON COLUMN md_synonyms.name
IS
         'Synonym name //OBJECTNAME';
COMMENT ON COLUMN md_synonyms.synonym_for_id
IS
         'What object this is a synonym for';
COMMENT ON COLUMN md_synonyms.for_object_type
IS
         'The type this is a synonym for (e.g. INDEX)';
COMMENT ON COLUMN md_synonyms.private_visibility
IS
         'Visibility - Private or Public.  If Private_visibility = ''Y'' means this is a private synonym.  Anything else means it is a public synonym';
COMMENT ON COLUMN md_synonyms.native_sql
IS
         'The SQL used to create this object at source';
COMMENT ON COLUMN md_synonyms.native_key
IS
         'An identifier for this object at source.';
COMMENT ON COLUMN md_migr_dependency.connection_id_fk
IS
         'The connection that this exists in //PARENTFIELD';
COMMENT ON COLUMN md_views.id
IS
         'Primary Key';
COMMENT ON COLUMN md_views.schema_id_fk
IS
         'The schema to which this obect blongs. //PARENTFIELD';
COMMENT ON COLUMN md_views.view_name
IS
         'The name of the view //OBJECTNAME';
COMMENT ON COLUMN md_views.native_sql
IS
         'The SQL used to create this object at source';
COMMENT ON COLUMN md_views.native_key
IS
         'An identifier for this object at source.';
COMMENT ON COLUMN md_views.LANGUAGE
IS '//PUBLIC';
COMMENT ON COLUMN md_projects.id
IS
         'Primary key';
COMMENT ON COLUMN md_projects.project_name
IS
         'Name of the project //OBJECTNAME';
COMMENT ON COLUMN md_columns.id
IS
         'Primary Key';
COMMENT ON COLUMN md_columns.table_id_fk
IS
         'The table that this column is part of //PARENTFIELD';
COMMENT ON COLUMN md_columns.column_name
IS
         'The name of the column //OBJECTNAME';
COMMENT ON COLUMN md_columns.column_order
IS
         'The order this appears in the table';
COMMENT ON COLUMN md_columns.column_type
IS
         'The type of the column';
COMMENT ON COLUMN md_columns.PRECISION
IS
         'The precision on the column';
COMMENT ON COLUMN md_columns.scale
IS
         'The scale of the column';
COMMENT ON COLUMN md_columns.nullable
IS
         'Yes or No.  Null signifies NO';
COMMENT ON COLUMN md_columns.default_value
IS
         'Default value on the column';
COMMENT ON COLUMN md_columns.native_sql
IS
         'The SQL used to create this column at source';
COMMENT ON COLUMN md_columns.native_key
IS
         'Unique identifier for this object at source';
COMMENT ON COLUMN md_columns.datatype_transformed_flag
IS
         'This is set to ''Y'' to show if the data type was transformed.  This is useful so we don''t apply more than 1 datatype transformation to a column';
COMMENT ON COLUMN md_group_members.id
IS
         'Primary Key';
COMMENT ON COLUMN md_group_members.user_id_fk
IS
         'Id of member';
COMMENT ON COLUMN md_group_members.group_member_id_fk
IS
         'groups can be members of groups';
COMMENT ON COLUMN md_users.id
IS
         'Primary Key';
COMMENT ON COLUMN md_users.schema_id_fk
IS
         'Shema in which this object belongs //PARENTFIELD';
COMMENT ON COLUMN md_users.username
IS
         'Username for login //OBJECTNAME';
COMMENT ON COLUMN md_users.password
IS
         'Password for login';
COMMENT ON COLUMN md_users.native_sql
IS
         'SQL Used to create this object at source';
COMMENT ON COLUMN md_users.native_key
IS
         'Unique identifier for this object at source.';
COMMENT ON COLUMN md_triggers.id
IS
         'Primary Key';
COMMENT ON COLUMN md_triggers.table_or_view_id_fk
IS
         'Table on which this trigger fires';
COMMENT ON COLUMN md_triggers.trigger_on_flag
IS
         'Flag to show iif the trigger is on a table or a view.  If it is a table this should be ''T''. If it is on a view this should be ''V''';
COMMENT ON COLUMN md_triggers.trigger_name
IS
         'Name of the trigger //OBJECTNAME';
COMMENT ON COLUMN md_triggers.trigger_timing
IS
         'before, after ,etc.';
COMMENT ON COLUMN md_triggers.trigger_operation
IS
         'insert, delete, etc.';
COMMENT ON COLUMN md_triggers.trigger_event
IS
          'The actual trigger that gets fired ';
COMMENT ON COLUMN md_triggers.native_sql
IS
          'The full definition ';
COMMENT ON COLUMN md_triggers.native_key
IS
         'UInique identifer for this object at source';
COMMENT ON COLUMN md_triggers.LANGUAGE
IS '//PUBLIC';
COMMENT ON COLUMN md_tables.id
IS
         'Primary Key';
COMMENT ON COLUMN md_tables.schema_id_fk
IS
         'Schema in which this table resides //PARENTFIELD';
COMMENT ON COLUMN md_tables.TABLE_NAME
IS
         'Name of the table //OBJECTNAME';
COMMENT ON COLUMN md_tables.native_sql
IS
         'SQL Used to create this table at soruce';
COMMENT ON COLUMN md_tables.native_key
IS
         'Unique identifier for this table at source';
COMMENT ON COLUMN md_groups.id
IS
         'Primary Key';
COMMENT ON COLUMN md_groups.schema_id_fk
IS
         'Schema in which this object belongs //PARENTFIELD';
COMMENT ON COLUMN md_groups.group_name
IS
         'Name of the group //OBJECTNAME';
COMMENT ON COLUMN md_groups.group_flag
IS
         'This is a flag to signify a group or a role.  If this is ''R'' it means the group is known as a Role.  Any other value means it is known as a group.';
COMMENT ON COLUMN md_groups.native_sql
IS
         'SQL Used to generate this object at source';
COMMENT ON COLUMN md_groups.native_key
IS
         'Unique id for this object at source';
COMMENT ON COLUMN md_stored_programs.id
IS
         'Primary Key';
COMMENT ON COLUMN md_stored_programs.schema_id_fk
IS
         'Schema to which this object belongs.  Note that the PACKAGE_ID_FK (if present also leads us to the relevant schema), however a stored program may or may not belong in a package.  If it is in a package, then the SCHEMA_ID_FK and the SCHEME_ID_FK in the parent package should match //PARENTFIELD';
COMMENT ON COLUMN md_stored_programs.programtype
IS
         'Java/TSQL/PLSQL, etc.';
COMMENT ON COLUMN md_stored_programs.name
IS
         'Name of the stored program //OBJECTNAME';
COMMENT ON COLUMN md_stored_programs.package_id_fk
IS
         'The package to which this object belongs';
COMMENT ON COLUMN md_stored_programs.native_sql
IS
         'The SQL used to create this object at source';
COMMENT ON COLUMN md_stored_programs.native_key
IS
         'A unique indetifier for this object at source';
COMMENT ON COLUMN md_stored_programs.LANGUAGE
IS '//PUBLIC';
COMMENT ON COLUMN md_migr_weakdep.child_name
IS
         'name of the child,  as weak dependencies dont have reference to child id';
COMMENT ON COLUMN md_migr_weakdep.parent_type
IS
         'MD_<tablename>';
COMMENT ON COLUMN md_migr_weakdep.child_type
IS
         'Generic Type (not MD_<tablename>)';
COMMENT ON COLUMN md_constraint_details.id
IS
         'Primary Key';
COMMENT ON COLUMN md_constraint_details.ref_flag
IS
         '"N" or Null signify that this column is the colum that is used in the constraint.  A flag of Y signifies that the colum is a referenced column (i.e. part of a foreign key constraint)';
COMMENT ON COLUMN md_constraint_details.constraint_id_fk
IS
         'Constraint that this detail belongs to //PARENTFIELD';
COMMENT ON COLUMN md_constraint_details.column_portion
IS
         'The portion of a column this detail belongs (e.g. for constrints on substrings)';
COMMENT ON COLUMN md_constraint_details.constraint_text
IS
         'The text of the constraint';
COMMENT ON COLUMN md_sequences.id
IS
         'Primary Key';
COMMENT ON COLUMN md_sequences.schema_id_fk
IS
         'The schema to which this object belongs. //PARENTFIELD';
COMMENT ON COLUMN md_sequences.name
IS
         'Name of this sequence //OBJECTNAME';
COMMENT ON COLUMN md_sequences.seq_start
IS
         'Starting point of the sequence';
COMMENT ON COLUMN md_sequences.incr
IS
         'Increment value of the sequence';
COMMENT ON COLUMN md_sequences.native_sql
IS
         'SQL used to create this object at source';
COMMENT ON COLUMN md_sequences.native_key
IS
         'Identifier for this object at source.';
COMMENT ON COLUMN md_migr_parameter.connection_id_fk
IS
         'the connection in which this belongs //PARENTFIELD';
COMMENT ON COLUMN md_migr_parameter.param_existing
IS
         '1 represents a new parameter for PL/SQL that was not present in the origional. 0 represents a n existing parameter that was present in the origional';
COMMENT ON COLUMN md_migr_parameter.param_order
IS
         'IF -1 THEN THIS PARAM IS A RETURN PARAMETER. 1 WILL BE THE FIRST PARAMETER IN THE PARAMETER LIST';
COMMENT ON COLUMN md_catalogs.connection_id_fk
IS
         'Foreign key into the connections table - Shows what connection this catalog belongs to //PARENTFIELD';
COMMENT ON COLUMN md_catalogs.catalog_name
IS
         'Name of the catalog //OBJECTNAME';
COMMENT ON COLUMN md_catalogs.dummy_flag
IS
         'Flag to show if this catalog is a "dummy" catalog which is used as a placeholder for those platforms that do not support catalogs.  ''N'' signifies that this is NOT a dummy catalog, while ''Y'' signifies that it is.';
COMMENT ON COLUMN md_catalogs.native_sql
IS
         'THe SQL used to create this catalog';
COMMENT ON COLUMN md_catalogs.native_key
IS
         'A unique identifier used to identify the catalog at source.';
COMMENT ON COLUMN md_tablespaces.id
IS
         'Primary Key';
COMMENT ON COLUMN md_tablespaces.schema_id_fk
IS
         'Schema to which this tablespace belongs //PARENTFIELD';
COMMENT ON COLUMN md_tablespaces.tablespace_name
IS
         'Name of the table space //OBJECTNAME';
COMMENT ON COLUMN md_tablespaces.native_sql
IS
         'The SQL used to create this tablespace';
COMMENT ON COLUMN md_tablespaces.native_key
IS
         'A unique identifier for this object at source';
COMMENT ON COLUMN md_index_details.index_id_fk
IS
         'The index to which this detail belongs. //PARENTFIELD';
COMMENT ON COLUMN md_index_details.index_portion
IS
         'To support indexing on part of a field';
COMMENT ON COLUMN migr_datatype_transform_map.id
IS
         'Primary Key';
COMMENT ON COLUMN migr_datatype_transform_map.project_id_fk
IS '//PARENTFIELD';
COMMENT ON COLUMN migr_datatype_transform_map.map_name
IS
         'A name for the map';
COMMENT ON COLUMN md_constraints.id
IS
         'Primary Key';
COMMENT ON COLUMN md_constraints.delete_clause
IS
         'delete option , can be either CASCADE, RESTRICT or NULL';
COMMENT ON COLUMN md_constraints.name
IS
         'Name of the constraint //OBJECTNAME';
COMMENT ON COLUMN md_constraints.constraint_type
IS
         'Type of the constraint (e.g. CHECK)';
COMMENT ON COLUMN md_constraints.table_id_fk
IS
         'Table on which this constraint exists //PARENTFIELD';
COMMENT ON COLUMN md_constraints.reftable_id_fk
IS
         'Used in foreign keys - this gives the table that we refer to.';
COMMENT ON COLUMN md_constraints.constraint_text
IS
         'The text of the constraint';
COMMENT ON COLUMN md_constraints.LANGUAGE
IS '//PUBLIC';
COMMENT ON COLUMN migr_datatype_transform_rule.id
IS
         'Primary Key';
COMMENT ON COLUMN migr_datatype_transform_rule.map_id_fk
IS
         'The map to which this rule belongs //PARENTFIELD';
COMMENT ON COLUMN migr_datatype_transform_rule.source_data_type_name
IS
         'Source data type';
COMMENT ON COLUMN migr_datatype_transform_rule.source_precision
IS
         'Precison to match';
COMMENT ON COLUMN migr_datatype_transform_rule.source_scale
IS
         'scale to match';
COMMENT ON COLUMN migr_datatype_transform_rule.target_data_type_name
IS
         'data type name to transform to';
COMMENT ON COLUMN migr_datatype_transform_rule.target_precision
IS
          'precision to map to ';
COMMENT ON COLUMN migr_datatype_transform_rule.target_scale
IS
         'scale to map to';
COMMENT ON COLUMN md_derivatives.transformed
IS
         'Set this field to ''Y'' if we carry out any sort of transformation on teh derived object.';
COMMENT ON COLUMN md_connections.id
IS
         'Primary key';
COMMENT ON COLUMN md_connections.project_id_fk
IS
         'The project to which this connection belongs //PARENTFIELD';
COMMENT ON COLUMN md_connections.type
IS
         'The type of the connection - For example it could be used to store "ORACLE" or "MYSQL"';
COMMENT ON COLUMN md_connections.host
IS
         'The host to which this connection connects.';
COMMENT ON COLUMN md_connections.port
IS
         'The port to which this connection connects';
COMMENT ON COLUMN md_connections.username
IS
         'The username used to make the connection';
COMMENT ON COLUMN md_connections.password
IS
         'The password used to make this connection';
COMMENT ON COLUMN md_connections.dburl
IS
         'The database url used to make this connection';
COMMENT ON COLUMN md_connections.name
IS '//OBJECTNAME';
COMMENT ON COLUMN md_connections.native_sql
IS
         'The native sql used to create this connection';
COMMENT ON COLUMN md_schemas.id
IS
         'Primary Key';
COMMENT ON COLUMN md_schemas.catalog_id_fk
IS
         'Catalog to which this schema blongs //PARENTFIELD';
COMMENT ON COLUMN md_schemas.name
IS
         'Name of the schema //OBJECTNAME';
COMMENT ON COLUMN md_schemas.type
IS
         'Type of this schema.  Eaxamples are ''CAPTURED'' OR ''CONVERTED''';
COMMENT ON COLUMN md_schemas.character_set
IS
         'The characterset of this schema';
COMMENT ON COLUMN md_schemas.version_tag
IS 'A version string that can be used for tagging/baseling a schema';
COMMENT ON COLUMN md_schemas.native_sql
IS
         'The native SQL used to create this schema';
COMMENT ON COLUMN md_schemas.native_key
IS
         'A unique identifier that this schema is known as in its source state.';
CREATE sequence dbobjectid_sequence increment BY 50 START WITH 1 maxvalue 999999999999999999999999 minvalue 1 cache 50;