/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide;

/**
 * IDE constants. Defines constants identifying a common set of IDE components,
 * such as, views, menus, etc.. These components are generally identified
 * with a unique string name that will be mapped to the real IDE 
 * component by the IDE provider. 
 */

public final class IDEConstants
{
  /**
   * Identifies the {@link IDE} environment object.
   */
  public static final String IDE_ENVIRONMENT = "javax.ide.IDE";

  /**
   * View and menu identifiers. View identifiers identify standard IDE views,
   * while menu identifiers identify where extensions can add their own 
   * menu items.
   */

  /**
   * Identifies the main window.
   */
  public static final String MAIN_WINDOW_ID = "javax.ide.view.MAIN_WINDOW_ID";

  /**
   * Identifies the main window's menubar.
   */
  public static final String MAIN_WINDOW_MENUBAR_ID = 
                                        "javax.ide.view.MAIN_WINDOW_MENUBAR_ID";

  /**
   * Identifies the main window's toolbar.
   */
  public static final String MAIN_WINDOW_TOOLBAR_ID = 
                                        "javax.ide.view.MAIN_WINDOW_TOOLBAR_ID";

  /**
   * Identifies the project explorer window.
   */
  public static final String PROJECT_EXPLORER_ID = 
                                          "javax.ide.view.PROJECT_EXPLORER_ID"; 
  
  /**
   * Identifies the project explorer's popup menu
   */
  public static final String PROJECT_EXPLORER_POPUP_ID = 
                                    "javax.ide.view.PROJECT_EXPLORER_POPUP_ID";

  /**
   * Identifies the log window.
   */
  public static final String LOG_PAGE_ID = "javax.ide.view.LOG_PAGE_ID";

  /**
   * Identifies the log window's popup menu
   */
  public static final String LOG_PAGE_POPUP_ID = 
                                          "javax.ide.view.LOG_PAGE_POPUP_ID";

  /**
   * Identifies the editor view.
   */
  public static final String EDITOR_ID = "javax.ide.view.EDITOR_ID";

  /**
   * Identifies the editor's popup menu.
   */
  public static final String EDITOR_POPUP_ID = 
                                          "javax.ide.view.EDITOR_POPUP_ID";

  /**
   * Menu item identifiers. There are three types of menu items identifyed by
   * these identifiers.  These are: main menubar pulldown menus, sections, 
   * and actions. 
   * <p>
   * Main menubar pulldown menus are the set of standard IDE menus common 
   * to all IDEs.  Menu sections are collections of menu items enclosed 
   * within separators. Actions are the executable menu items. 
   *
   * Others TBD.
   */
  
  /**
   * Identifies the File menu id.
   */
  public static final String FILE_MENU_ID = "javax.ide.FILE_MENU_ID";

  /**
   * Identifies the Edit menu id.
   */
  public static final String EDIT_MENU_ID = "javax.ide.EDIT_MENU_ID";

  /**
   * Identifies the View menu id.
   */
  public static final String VIEW_MENU_ID = "javax.ide.VIEW_MENU_ID";

  /**
   * Identifies the Help menu id.
   */
  public static final String HELP_MENU_ID = "javax.ide.HELP_MENU_ID";

  /**
   * Identifies the New menu section.
   */
  public static final String NEW_SECTION_ID = "javax.ide.NEW_SECTION_ID";

  /**
   * Identifies the Open menu section.
   */
  public static final String OPEN_SECTION_ID = "javax.ide.OPEN_SECTION_ID";

  /**
   * Identifies the Save menu section.
   */
  public static final String SAVE_SECTION_ID = "javax.ide.SAVE_SECTION_ID";
  
  /**
   * Identifies the Close menu section.
   */
  public static final String CLOSE_SECTION_ID = "javax.ide.CLOSE_SECTION_ID";

  /**
   * Identifies the Print menu section.
   */
  public static final String PRINT_SECTION_ID = "javax.ide.PRINT_SECTION_ID";

  /**
   * Identifies the Open menu action.
   */
  public static final String OPEN_ACTION_ID = "javax.ide.OPEN_ACTION_ID";

  /**
   * Identifies the Save menu action.
   */
  public static final String SAVE_ACTION_ID = "javax.ide.SAVE_ACTION_ID";

  /**
   * Identifies Cut menu action.
   */ 
  public static final String CUT_ACTION_ID = "javax.ide.CUT_ACTION_ID";
  
  /**
   * Identifies the Copy menu action.
   */
  public static final String COPY_ACTION_ID = "javax.ide.COPY_ACTION_ID";
  
  /**
   * Identifies the Paste menu action.
   */
  public static final String PASTE_ACTION_ID = "javax.ide.PASTE_ACTION_ID";
  
  /**
   * Identifies the Cut/Copy/Paste section.
   */
  public static final String COPY_PASTE_SECTION_ID = "javax.ide.COPY_PASTE_SECTION_ID";

  /**
   * The Java wizard category
   */
  public static final String JAVA_WIZARD_CATEGORY_ID = "javax.ide.wizard.JAVA_WIZARD_CATEGORY";
  
  /**
   * The Web wizard category
   */
  public static final String WEB_WIZARD_CATEGORY_ID = "javax.ide.wizard.WEB_WIZARD_CATEGORY";

  /**
   * The XML wizard category
   */
  public static final String XML_WIZARD_CATEGORY_ID = "javax.ide.wizard.XML_WIZARD_CATEGORY";


  //--------------------------------------------------------------------------
  // Private methods.
  //--------------------------------------------------------------------------
  
  /*
   * Don't allow construction of this class
   */
  private IDEConstants(){}
}
