/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.extension;
import java.util.Collection;

/**
 * The context when visiting an xml start element.
 */
public interface ElementStartContext extends ElementContext
{
  /**
   * Get the (local) names of all attributes available on the current
   * element.
   * 
   * @return an unmodifiable collection of attribute names.
   */
  Collection getAttributeNames();
  
  /**
   * Get the value of an attribute defined on the current element.
   * 
   * @param attributeName the name of an attribute defined on the current
   *  element.
   * @return the value of the specified attribute, or null if no such 
   *  attribute is defined.
   */
  String getAttributeValue( String attributeName );
}
