/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.extension.spi;

import org.xml.sax.Locator;

final class LocatorImpl implements Locator
{
  private final String _publicId;
  private final String _systemId;
  private final int _column;
  private final int _line;

  public LocatorImpl(String publicId, String systemId, int column, int line )
  {
    _publicId = publicId;
    _systemId = systemId;
    _column = column;
    _line = line;
  }

  public LocatorImpl(String publicId, String systemId )
  {
    this( publicId, systemId, 0, 0 );
  }

  public LocatorImpl(String systemId )
  {
    this( systemId, systemId );
  }


  public int getColumnNumber()
  {
    return _column;
  }

  public int getLineNumber()
  {
    return _line;
  }

  public String getPublicId()
  {
    return _publicId;
  }

  public String getSystemId()
  {
    return _systemId;
  }

}
