/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.menu.spi;

import java.util.List;

/**
 * Section Container is a container of sections. This corresponds to the
 * sectionContainerType schema type.
 */
public class SectionContainer extends Positionable
{
  private final PositionMap _sections = new PositionMap();

  public SectionContainer( String id )
  {
    super( id );
  }
  
  void addSection( Section section )
  {
    _sections.add( section );
  }

  /**
   * Get the sections in this container. 
   * 
   * @return a Collection of Section instances. 
   */
  public List getSections()
  {
    return _sections.getSortedItems();
  }

  public Section getSection(String id)
  {
    return (Section)_sections.get(id);
  }
}
