/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.menu.spi;

import java.util.logging.Level;

import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;


final class ToolbarsVisitor extends ElementVisitor
{
  private static final ElementName TOOLBAR = element( "toolbar" );

  private final static ElementName element( String name )
  {
    return new ElementName( ExtensionHook.MANIFEST_XMLNS, name );
  }

  private final ElementVisitor _toolbarHandler = new ToolbarHandler();
  
  public void start( ElementStartContext context )
  {
    context.registerChildVisitor( TOOLBAR, _toolbarHandler );
  }
  
  private class ToolbarHandler extends ElementVisitor
  {
    private final ElementVisitor _sectionHandler = new SectionVisitor();
    
    public void start( ElementStartContext context )
    {
      String id = context.getAttributeValue( "id" );
      if ( id == null || (id = id.trim()).length() == 0 )
      {
        log( context, Level.SEVERE, "Missing required attribute 'id'." );
        return;
      }

      MenuModel model = 
        (MenuModel) context.getScopeData().get( MenuHook.KEY_MENU_MODEL );
      
      Toolbar toolbar = model.findOrCreateToolbar( id );
      context.getScopeData().put( MenuHook.KEY_SECTION_CONTAINER, toolbar );      
      context.registerChildVisitor( SectionVisitor.SECTION, _sectionHandler );
    }
  }
  

}
