/*
 * @(#)MemberD.java
 */

package javax.ide.model.java.declaration;

/**
 * Represents a member declaration, part of a type declaration.
 *
 * @author Andy Yu
 */
public interface MemberD
  extends Declaration
{
  // ----------------------------------------------------------------------

  /**
   * Gets the declaring class.
   *
   * @return The class declaration for the declaring class.
   */
  public ClassD getEnclosingClass();

  /**
   * Gets the modifiers for this member. May be decoded with
   * {@link java.lang.reflect.Modifier}.
   *
   * @return The modifier mask for this member.
   */
  public int getModifiers();


  // ----------------------------------------------------------------------

  /**
   * True if this is modified with "public".
   *
   * @return True if this is modified with "public".
   */
  public boolean isPublic();

  /**
   * True if this is modified with "private".
   *
   * @return True if this is modified with "private".
   */
  public boolean isPrivate();

  /**
   * True if this is modified with "protected".
   *
   * @return True if this is modified with "protected".
   */
  public boolean isProtected();

  /**
   * True if this is modified with "static".
   *
   * @return True if this is modified with "static".
   */
  public boolean isStatic();

  /**
   * True if this is modified with "final".
   *
   * @return True if this is modified with "final".
   */
  public boolean isFinal();

}
