/*
 * @(#)SuperclassT.java
 */

package javax.ide.model.java.source.tree;

/**
 * A superclass clause of a type declaration. On a "class"
 * type, this is the "extends" clause.
 * 
 * @author Andy Yu
 * */
public interface SuperclassT
  extends Tree
{
  // ----------------------------------------------------------------------
  
  /**
   * Gets the type reference for this element.
   *
   * @return This element's type reference.
   */
  public TypeReferenceT getType();


  /**
   * Unlinks the current source type and links the input element.
   * 
   * @param type The new type reference.
   *
   * @throws IllegalStateException if the input type is already linked.
   */
  public void setType( TypeReferenceT type );

}
