/*
 * @(#)TypeExpressionT.java
 */

package javax.ide.model.java.source.tree;

/**
 * An expression wrapping a type reference. The following operators
 * all have type operands (which are type expressions): instanceof,
 * typecast, class literal, and qualified this literal. <p/>
 *
 * Type expressions have no operands.
 *
 * @author Andy Yu
 * */
public interface TypeExpressionT
  extends ExpressionT
{
  // ----------------------------------------------------------------------
  
  /**
   * Gets the type reference for this element.
   *
   * @return This element's type reference.
   */
  public TypeReferenceT getType();


  /**
   * Unlinks the current source type and links the input element.
   * 
   * @param type The new type reference.
   *
   * @throws IllegalStateException if the input type is already linked.
   */
  public void setType( TypeReferenceT type );

}
