 # @(#)master_4.sh
 #
 # Copyright 2006 by Oracle Corporation,
 # 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 # All rights reserved.
 #
 # This software is the confidential and proprietary information
 # of Oracle Corporation. 
 
export user=SET_USER_NAME
export host=SET_THE_HOST
export password=SET_THE_PASSWORD
export SEED=$RANDOM

ERROR_CONDITION="N"
if [[ $user = "SET_USER_NAME" ]]; then 
   ERROR_CONDITION="Y"
fi
if [[ $host = "SET_THE_HOST" ]]; then 
   ERROR_CONDITION="Y"
fi
if [[ $password = "SET_THE_PASSWORD" ]]; then 
   ERROR_CONDITION="Y"   
fi

if [[ $ERROR_CONDITION = "Y" ]]; then
echo "You need to enter either user or host or password at the beginning of script."

else

echo "SEED="$SEED >> mysql4.ocp

echo "SELECT VERSION()" > version$SEED.sql

mysql -u$user -p$password -h$host < version$SEED.sql >version$SEED.txt

echo SHOW DATABASES > showdatabases.sql

mysql -u$user -p$password -h$host < showdatabases.sql >temp_databases$SEED.txt

temp_db_file=temp_databases$SEED.txt
while read token
do
if [[ $token != "mysql" ]]; then
 if [[ $token != "Database" ]]; then
      ./get_table.sh $token
 fi
fi
done < $temp_db_file

echo table_info=all_tabs$SEED.txt >> mysql4.ocp

echo column_table_info=all_col_data_tabs$SEED.txt >> mysql4.ocp

echo constraint_table_info=all_constraints_tabs$SEED.txt >> mysql4.ocp

echo max_column_info=all_cols_tabs$SEED.txt >> mysql4.ocp

echo index_info=all_index_data_tabs$SEED.txt >> mysql4.ocp

echo version_info=version$SEED.txt >> mysql4.ocp

echo Offline MySQL File Generation Completed

echo Processing completed - files generated for MySQL Offline

fi
