#!/bin/sh
 # @(#)master_5.sh
 #
 # Copyright 2006 by Oracle Corporation,
 # 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 # All rights reserved.
 #
 # This software is the confidential and proprietary information
 # of Oracle Corporation. 
 
export user=SET_USER_NAME
export host=SET_THE_HOST
export password=SET_THE_PASSWORD
export SEED=$RANDOM

ERROR_CONDITION="N"
if [[ $user = "SET_USER_NAME" ]]; then 
   ERROR_CONDITION="Y"
fi
if [[ $host = "SET_THE_HOST" ]]; then 
   ERROR_CONDITION="Y"
fi
if [[ $password = "SET_THE_PASSWORD" ]]; then 
   ERROR_CONDITION="Y"   
fi

if [[ $ERROR_CONDITION = "Y" ]]; then
echo "You need to enter either user or host or password at the beginning of script."

else

echo "SEED="$SEED >> mysql5.ocp

echo "SELECT VERSION()" > version$SEED.sql

mysql -u$user -p$password -h$host < version$SEED.sql > version$SEED.txt

mysqldump -u$user -p$password -h$host --xml --no-data --all-databases > alldbs$SEED.xml

echo alldbsfile=alldbs$SEED.xml >> mysql5.ocp

echo "select SCHEMA_NAME from information_schema.schemata where (SCHEMA_NAME NOT IN ('information_schema','mysql'));"> showdatabases.sql

mysql -u$user -p$password -h$host < showdatabases.sql >temp_databases$SEED.txt

temp_db_file=temp_databases$SEED.txt
while read token
do
if [[ $token != "SCHEMA_NAME" ]]; then
      ./get_table_5.sh $token
fi
done < $temp_db_file

echo "SELECT TABLE_SCHEMA, TABLE_NAME, VIEW_DEFINITION, DEFINER  FROM INFORMATION_SCHEMA.VIEWS;"> showviews$SEED.sql

mysql -u$user -p$password -h$host < showviews$SEED.sql>views$SEED.txt

echo "SELECT ROUTINE_SCHEMA,ROUTINE_NAME , ROUTINE_TYPE , DEFINER FROM INFORMATION_SCHEMA.ROUTINES;"> routines_name$SEED.sql

mysql -u$user -p$password -h$host < routines_name$SEED.sql>temp_routines$SEED.txt

while read f1 f2 f3 f4
do  
  if [[ $f1 == "ROUTINE_SCHEMA" ]]; then      
   continue
  else
    ./get_stored_proc_5.sh $f1 $f2 $f3 $f4
  fi
done < temp_routines$SEED.txt

echo table_info=alltabs$SEED.txt >> mysql5.ocp

echo column_table_info=all_col_data_tabs$SEED.txt >> mysql5.ocp

echo constraint_table_info=all_constraints_tabs$SEED.txt >> mysql5.ocp

echo max_column_info=all_cols_tabs$SEED.txt >> mysql5.ocp

echo index_info=all_index_data_tabs$SEED.txt >> mysql5.ocp

echo views_info=views$SEED.txt >> mysql5.ocp

echo routines_info=routines$SEED.txt >> mysql5.ocp

echo version_info=version$SEED.txt >> mysql5.ocp

echo Processing completed - files generated for MySQL Offline

fi
