declare namespace wsdl = "http://schemas.xmlsoap.org/wsdl/";
declare namespace xsd = "http://www.w3.org/2001/XMLSchema";
declare namespace xmlef_func = "http://xmlns.oracle.com/bali/xml/xquery";

(: Declare external functions  :)

declare function xmlef_func:location($doc as item(), $namespace as xsd:string, $location as xsd:string*) as node()* external;


(: lookup the named element in the current document :)

declare function local:lookupInDocument(
  $doc as node(), 
  $namespace as xsd:string,
  $elementToLookup as xsd:string, 
  $lookupAttribute as xsd:string,
  $valueToLookup as xsd:string) as node()*
{
  for $schemaDefinition in $doc/xsd:schema[@targetNamespace=$namespace or $namespace = '*']
    return if ('type'=$elementToLookup) then
             for $found in ($schemaDefinition//xsd:simpleType[@name=$valueToLookup or $valueToLookup = '*'] | $schemaDefinition//xsd:complexType[@name=$valueToLookup or $valueToLookup = '*'])
               return $found
           else
             for $found in $schemaDefinition//xsd:element[@name=$valueToLookup or $valueToLookup = '*']
               return $found  
};

 
(: Resolve all import statment for the given namespace :)

declare function local:lookupImportStatements(
  $doc as node(),
  $namespace as xsd:string) as xsd:string*
{
  for $found in ($doc/xsd:schema[@targetNamespace=$namespace or $namespace = '*']/xsd:import | $doc/xsd:schema/xsd:import[@namespace=$namespace  or $namespace = '*'])
    return xsd:string($found/@schemaLocation)
}; 


(: Actually resolve and load the referenced documents :)

declare function local:lookupImportedDocumentsForNamespace(
  $doc as node(),
  $namespace as xsd:string) as node()*
{
  for $importedDoc in xmlef_func:location($doc, $namespace,
    local:lookupImportStatements($doc, $namespace))
    return $importedDoc
};


(: Declare external variables and functions :)



declare variable $this as node() external;
declare variable $isSchema as xsd:boolean external;
declare variable $namespace as xsd:string external;
declare variable $elementToLookup as xsd:string external;
declare variable $lookupAttribute as xsd:string external;
declare variable $valueToLookup as xsd:string external;




declare variable $referencesInThisDocument := local:lookupInDocument(
  $this, $namespace, $elementToLookup, $lookupAttribute, $valueToLookup);
    
declare variable $externalReferences :=
  for $importedDoc as node() in local:lookupImportedDocumentsForNamespace(
                              $this,
                              $namespace)
    return local:lookupInDocument(
                   $importedDoc, 
                   $namespace, 
                   $elementToLookup, 
                   $lookupAttribute, 
                   $valueToLookup); 
  

for $i in ($referencesInThisDocument | $externalReferences)
  return $i